<?php

namespace App\Webapi\Controllers;
use Phalcon\DI;

class RestController extends \App\Core\Controllers\BaseController
{

    public function v1Action(){

        $startTime = date('m-d-Y h:i:s', time());
        $start_time = microtime(true);
        $this->di->getObjectManager()->get('\App\Webapi\Components\Helper')
                ->loadAreaConfigurations();

        $apiRoute = implode('/', $this->router->getParams());
        $httpMethod = $this->request->getMethod();

        $route = $this->di->getConfig()->get('restapi')->get('v1')
                   ->get($httpMethod)->get('routes')->get($apiRoute);

        if ($route) {
            $method = $route->method;

            if (!$this->checkAcl($route)) {
                return $this->prepareResponse(['success'=>false,'code'=>'403','msg'=>'Access forbidden.']);
            }
            if ($this->validateRequired($route)) {
                $requestData = $this->getRequestData();

                /** request modifier start **/
                if ($route->get('request_modifier_class') && class_exists($route->request_modifier_class)) {
                    $requestData = $this->di->getObjectManager()
                                    ->get($route->request_modifier_class)
                                    ->$method($requestData);

                } elseif ($route->get('component')) {

                    $instance = new class extends \App\Apiconnect\Api\Request\Base{
                        protected $_component;
                    };
                    $this->di->setShared(
                        "apiComponentRequest",
                        function () use($instance){
                            return $instance;
                        }
                    );
                    $instance = $this->di->getApiComponentRequest();
                   
                    $requestData = $instance->setComponent($route->component)
                                    ->$method($requestData);
                }

                if((isset($requestData['success']) && $requestData['success'] === false)){
                    return $this->prepareResponse($requestData);
                }
                /** request modifier end **/
                if ($route->get('class') && class_exists($route->class)) {
                   $apiResponse = $this->di->getObjectManager()->get($route->class)
                                    ->$method($requestData);
                } else {
                    $instance = new class extends \App\Apiconnect\Api\Base{
                        protected $_component;
                    };
                    $this->di->setShared(
                        "anonymousApiComponent",
                        function () use($instance){
                            return $instance;
                        }
                    );
                    $instance = $this->di->getAnonymousApiComponent();
                    $apiResponse = $instance->setComponent($route->component)
                                    ->$method($requestData);
                }


                if (!isset($this->di->getRegistry()->getHeaders()['Response-Modifier']) || $this->di->getRegistry()->getHeaders()['Response-Modifier'] == 1) {
                    if ($route->get('response_class') && class_exists($route->response_class)) {
                        $apiResponse = $this->di->getObjectManager()
                                        ->get($route->response_class)
                                        ->$method($apiResponse);
                    } elseif ($route->get('component')) {
                        $instance = new class extends \App\Apiconnect\Api\Response\Base{
                            protected $_component;
                        };
                        $this->di->setShared(
                            "apiComponentResponse",
                            function () use($instance){
                                return $instance;
                            }
                        );
                        $instance = $this->di->getApiComponentResponse();
                        $apiResponse = $instance->setComponent($route->component)
                                        ->$method($apiResponse);
                    }
                }
                $apiResponse['start_time'] = $startTime;
                $apiResponse['end_time'] = date('m-d-Y h:i:s', time());
                $end_time = microtime(true);
                $execution_time = ($end_time - $start_time);
                $apiResponse['execution_time'] = $execution_time;
                return $this->prepareResponse($apiResponse);
            } else {
                return $this->prepareResponse(['success'=>false,'code'=>'422','msg'=>'Missing required params.']);
            }
        } else {
            return $this->prepareResponse(['success'=>false,'code'=>'404','msg'=>'Page not found']);
        }
    }

    public function checkAcl($route){
        $acl = unserialize(
            file_get_contents(BP . DS . 'app' . DS . 'etc' . DS . 'security' . DS . 'acl.data')
        );
        $module = 'webapi';
        $controller = $route->resource;
        $action = strtolower($this->request->getMethod());

        if ($acl->isAllowed($this->di->getUser()->role->getCode(), $module . '_' . $controller, $action)) {
            if($this->di->getRegistry()->getIsSubUser()){
                $subuser = $this->di->getSubUser();
                $child_acl = unserialize(
                    file_get_contents(BP . DS . 'app' . DS . 'etc' . DS . 'security' . DS .'child'.DS. 'acl_'.$subuser['_id'].'.data')
                );
                if ($child_acl->isAllowed('child_' . $subuser['_id'], $module . '_' . $controller, $action)) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

    public function validateRequired($route){
        $route = $route->toArray();
        if (isset($route['required'])) {
            foreach ($route['required'] as $key) {
                if (!array_key_exists($key, $this->getRequestData())) {
                    return false;
                }
            }
        }
        return true;
    }

    public function getRequestData(){
        switch ($this->request->getMethod()){
            case 'POST' :
                $contentType = $this->request->getHeader('Content-Type');
                if (strpos($contentType, 'application/json') !== false) {
                    $data = $this->request->getJsonRawBody(true);
                }
                else{
                    $data = $this->request->getPost();
                   // print_r($data);die;
                }
                break;
            case 'PUT' :
                $contentType = $this->request->getHeader('Content-Type');
                if (strpos($contentType, 'application/json') !== false) {
                    $data = $this->request->getJsonRawBody(true);
                }
                else{
                    $data = $this->request->getPut();
                   // print_r($data);die;
                }
                $data = array_merge($data,$this->request->get());
                break;

            case 'DELETE' :
                $contentType = $this->request->getHeader('Content-Type');
                if (strpos($contentType, 'application/json') !== false) {
                    $data = $this->request->getJsonRawBody(true);
                }
                else{
                    $data = $this->request->getPost();
                }
                $data = array_merge($data,$this->request->get());
                break;
            default:
                $data = $this->request->get();
                break;
        }
        return $data;
    }
}
