<?php
namespace App\Apiconnect\Models\Apps;

use App\Apiconnect\Models\Apps;

class Shop extends \App\Core\Models\BaseMongo
{
    protected $table = 'apps_shop';

    protected $isGlobal = true;

    /**
     * Add Shop in user_details table
     *
     * @param array $shopDetails ['name'=>'','domain'=>'','marketplace'=>'','warehouses'=>[['name'=>'','location'=>'']]]
     * @param int $userId
     * @param array $uniqueKeys ['domain', '_id']
     * @return array with success true/false and message
     */
    public function addShop($appId = false, $subAppId = false, $shopDetails, $uniqueKeys = ['domain']){

        if (empty($shopDetails)) {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insuficiant_data'];
        }

        $appConfig = $this->di->getRegistry()->getAppConfig();

        if($appConfig && !$appId){
            $appId = $appConfig['_id'];
        }

        if($appConfig && !$subAppId){
            $subAppId = $appConfig['sub_app_id'] ?? false;
        }
        $bulk = true;
        if(!isset($shopDetails[0])){
            $shopDetails = [$shopDetails];
            $bulk = false;
        }

        unset($shopDetails['app_id']);
        unset($shopDetails['sub_apps']);

        $result = [];
        foreach($shopDetails as $shopDetail){
            $collection = $this->getCollection();
            $filters = [];
            $filters['app_id'] = $appId;
            /*if($subAppId){
                $filters['sub_apps'] = $subAppId;
            }*/
            foreach ($uniqueKeys as $key) {
                if (isset($shopDetail[$key])) {
                    $filters["{$key}"] = $shopDetail[$key];
                }
            }

            $this->di->getLog()->logContent('result = '.json_encode($filters),'critical','shopify_home_auth.log');

            if(isset($shopDetail['_id'])){
                unset($shopDetail['_id']);
            }
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            try {
                $response = $collection->findOne($filters, $options);
                if($subAppId){
                    if (empty($response)){
                        /* add sub app in shopDetails*/
                        $shopDetail['sub_apps'] = [$subAppId];
                        $shopDetail['app_id'] = $appId;
                        $shopDetail['_id'] = $this->getCounter('app_shop_id');
                        $shop = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
                        $shop->setData($shopDetail);
                        $shop->save();
                        $result[] = ['success' => true,
                            'message' => 'Shop Added  Successfuly app',
                            'data'=>[
                                'shop_id'=> $shopDetail['_id']
                            ]
                        ];
                        continue;
                    }
                    else
                    {
                        $shopDetail['sub_apps'] = $response['sub_apps'];
                        $apps = array_flip($shopDetail['sub_apps']);
                        if(!isset($apps[$subAppId]))
                            $shopDetail['sub_apps'][] = $subAppId;
                        $updateResult = $collection->updateOne(
                            $filters,
                            ['$set' => $shopDetail]
                        );
                        if ($updateResult->getMatchedCount()) {
                            $result[] = ['success' => true,
                                'message' => 'Shop Updated Successfuly subapp',
                                'data'=>[
                                    'shop_id'=>$response['_id']
                                ]
                            ];
                            continue;
                        } else {
                            $result[] = ['success' => false, 'message' => 'Shop Update Failed'];
                            continue;
                        }
                    }
                }
                else{
                    if (empty($response)){
                        /* add sub app in shopDetails*/
                        $shopDetail['sub_apps'] = [];
                        $shopDetail['app_id'] = $appId;
                        $shopDetail['_id'] = $this->getCounter('app_shop_id');
                        $shop = $this->di->getObjectManager()->create('\App\Apiconnect\Models\Apps\Shop');
                        $shop->setData($shopDetail);
                        $shop->save();

                        $result[] = ['success' => true,
                            'message' => 'Shop Added Successfuly app',
                            'data'=>[
                                'shop_id'=> $shopDetail['_id']
                            ]
                        ];
                        continue;
                    }
                    else
                    {
                        $shopDetail['sub_apps'] = $response['sub_apps'];
                        $updateResult = $collection->updateOne(
                            $filters,
                            ['$set' => $shopDetail]
                        );
                        if ($updateResult->getMatchedCount()) {
                            $result[] = ['success' => true,
                                'message' => 'Shop Updated Successfuly app',
                                'data'=>[
                                    'shop_id'=>$response['_id']
                                ]
                            ];
                            continue;
                        } else {
                            $result[] = ['success' => false, 'message' => 'Shop Update Failed'];
                            continue;
                        }
                    }
                }

            } catch (\Exception $e){
                $result[] = ['success' => false, 'message' => $e->getMessage(), 'code' => 'unknown_exception'];
            }
        }
        $this->di->getLog()->logContent('result = '.json_encode($result),'critical','shopify_home_auth.log');
        return $bulk ? $result : $result[0];

    }

    public function getShop($appId = false, $subAppId = false, $shopDetails = [], $uniqueKeys = ['domain'], $findAll = false){
        unset($shopDetails['app_id']);
        unset($shopDetails['sub_apps']);
        $appConfig = $this->di->getRegistry()->getAppConfig();
        if($appConfig && !$appId){
            $appId = $appConfig['_id'];
        }

        if($appConfig && !$subAppId){
            $subAppId = $appConfig['sub_app_id'] ?? false;
        }
        /*if (empty($shopDetails)) {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insuficiant_data'];
        }*/
        $collection = $this->getCollection();
        $filters = [];
        $filters['app_id'] = $appId;
        if(!$findAll && $subAppId){
            $filters['sub_apps'] = $subAppId;
        }
        foreach ($uniqueKeys as $key) {
            if (isset($shopDetails[$key])) {
                $filters["{$key}"] = $shopDetails[$key];
            }
        }
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];
        try {
            $response = $collection->findOne($filters, $options);
            if (empty($response)){
                return ['success'=>false,'code'=>'shop_not_found','message'=>'Shop Not Found.'];
            }else{
                return ['success'=>true,'message'=>'','data'=>['shop_id'=>$response['_id'], 'datos' => $response]];
            }
        }catch (\Exception $e){
            return ['success' => false, 'message' => $e->getMessage(), 'code' => 'unknown_exception'];
        }
    }

    public function getById($shopId, $appId = false, $subAppId = false){
        $appConfig = $this->di->getRegistry()->getAppConfig();
        if($appConfig && !$appId){
            $appId = $appConfig['_id'];
        }

        if($appConfig && !$subAppId){
            $subAppId = $appConfig['sub_app_id'] ?? false;
        }

        $filters = [];
        $filters['_id'] = (int)$shopId;
        $filters['app_id'] = $appId;
        if($subAppId)
            $filters['sub_apps'] = $subAppId;
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];
        $collection = $this->getCollection();
        $response = $collection->findOne($filters, $options);
        return $response;
    }

    public function deleteShop($id = '')
    {
        if(empty($id)) return [
            'success' => false,
            'message' => 'id field required'
        ];
         $collection = $this->getCollection();
         $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];
         $response = $collection->deleteOne(
            ['_id' => (int)$id], $options
        );

        if($response->getDeletedCount() == 1){
            return [
                'success' => true,
                'message' => 'shop Successfuly deleted'
            ];
        } else {
            return [
                'success' => false,
                'message' => 'No shop found'
            ];
        }
    }
}