<?php
/**
 * CedCommerce
 **/
namespace App\Apiconnect\Components;
use Aws\DynamoDb\DynamoDbClient;


/**
 * Class Webhook
 * @package App\Code\Apiconnect\Components
 */
class Webhook extends Base
{

    public function validatePostData($data)
    {
        $required_indexes = ['queue_unique_id', 'queue_name', 'topic', 'type'];

        foreach ($required_indexes as $index) {
            if(strpos($index, '->') === false) {
                if(!isset($data[$index])) {
                    return [
                        'status' => false,
                        'error'  => "'{$index}' is required."
                    ];
                }
            }
            else {
                $expl = explode('->', $index);
                if(!isset($data[$expl[0]][$expl[1]])) {
                    return [
                        'status' => false,
                        'error'  => "'{$expl[0]}[{$expl[1]}]' is required."
                    ];
                }
            }
        }

        if(isset($data['queue_config']))
        {
            $required_indexes = ['queue_config->key', 'queue_config->secret', 'queue_config->region'];

            foreach ($required_indexes as $index) {
                if(strpos($index, '->') === false) {
                    if(!isset($data[$index])) {
                        return [
                            'status' => false,
                            'error'  => "'{$index}' is required."
                        ];
                    }
                }
                else {
                    $expl = explode('->', $index);
                    if(!isset($data[$expl[0]][$expl[1]])) {
                        return [
                            'status' => false,
                            'error'  => "'{$expl[0]}[{$expl[1]}]' is required."
                        ];
                    }
                }
            }
        }

        return ['status' => true];
    }

    public function updateAll()
    {
        $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');
        $result = $client->scan([
            'TableName' => 'queue_config', // REQUIRED
        ]);
        $items = $result->get('Items');
        foreach ($items as $item) {
            $result = $client->putItem([
                'Item' => [ // REQUIRED
                    'id' => [
                        'S' => (string)$item['id']['S'],
                    ],
                    'queue_type' => [
                        'S' => (string)$item['queue_type']['S'],
                    ],
                    'app_secret' => [
                        'S' => 'S3tApopngRltwXvIYVm8XoYjcEIZE0OgdGl7K8xh',
                    ],
                    'app_key' => [
                        'S' => 'AKIAU3EY6KRDQPFUVDWA',
                    ],
                    'queue_region' => [
                        'S' => (string)$item['queue_region']['S']
                    ],
                    'base_url' => [
                        'S' => (string)$item['base_url']['S']
                    ]
                ],
                'TableName' => 'queue_config', // REQUIRED
            ]);
        }
        die('done');
    }

    public function saveConfig($data)
    {
        try {
            $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

            $shop = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $result = $client->putItem([
                'Item' => [ // REQUIRED
                    'id' => [
                        'N' => (string)$appConfig['_id'],
                    ],
                    'app_id' => [
                        'S' => (string)$appConfig[$this->getApiMode($data)]['app_id'],
                    ],
                    'app_secret' => [
                        'S' => (string)$appConfig[$this->getApiMode($data)]['app_secret'],
                    ],
                    'marketplace' => [
                        'S' => $appConfig['marketplace']
                    ]
                ],
                'TableName' => 'apps', // REQUIRED
            ]);

            if(isset($data['queue_config']))
            {
                $result = $client->putItem([
                    'Item' => [ // REQUIRED
                        'id' => [
                            'S' => (string)$data['queue_unique_id'],
                        ],
                        'queue_type' => [
                            'S' => (string)$data['type'],
                        ],
                        'app_secret' => [
                            'S' => (string)$data['queue_config']['secret'],
                        ],
                        'app_key' => [
                            'S' => (string)$data['queue_config']['key'],
                        ],
                        'queue_region' => [
                            'S' => (string)$data['queue_config']['region']
                        ],
                        'base_url' => [
                            'S' => (string)$this->getQueueBaseUrl($data['queue_url'])
                        ]
                    ],
                    'TableName' => 'queue_config', // REQUIRED
                ]);
            }
            else
            {
                $result = $client->getItem([
                    'Key' => [ // REQUIRED
                        'id' => [
                            'S' => (string)$data['queue_unique_id'],
                        ],
                        
                    ],
                    'TableName' => 'queue_config', // REQUIRED
                ]);

                if(is_null($result->get('Item'))){
                    return [
                        'success' => false,
                        'message' => 'Queue does not exist. Pass existing queue id or pass queue id with queue_config',
                        'code' => 'queue_does_not_exist'
                    ];
                }
            }

            $result = $client->scan([
                'FilterExpression' => "shop_id=:shop_id AND app_id=:app_id AND topic=:topic",
                "ExpressionAttributeValues" => [
                    ":shop_id" => [
                        'N' => (string)$shop['_id']
                    ],
                    ":app_id" => [
                        'N' => (string)$appConfig['_id']
                    ],
                    ":topic" => [
                        'S' => (string)$data['topic']
                    ]
                ],
                'TableName' => 'webhook_config', // REQUIRED
            ]);
            $queueData = $data['queue_data']??[];
            
            if($result->get('Count') == 0)
            {
                

                $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
                $autoIncrementId = $mongo->getCounter('sqs_config_id');
                $itemData = [
                    'Item' => [
                        'id' => [
                            'N' => (string)$autoIncrementId,
                        ],
                        'shop_id' => [
                            'N' => (string)$shop['_id'],
                        ],
                        'app_id' => [
                            'N' => (string)$appConfig['_id'],
                        ],
                        'queue_reference_id' => [
                            'S' => (string)$data['queue_unique_id'],
                        ],
                        'topic' => [
                            'S' => (string)$data['topic']
                        ],
                        'queue_name' => [
                            'S' => (string)$data['queue_name']
                        ],
                        // 'address' => [
                        //     'S' => (string)$address
                        // ],
                        'queue_data' => [
                            'S' => (string)json_encode($queueData)
                        ]
                    ],
                    'TableName' => 'webhook_config', // REQUIRED
                ];

                if(isset($data['other_unique_ids'])) {
                    
                    foreach($data['other_unique_ids'] as $key => $value){
                        $itemData['Item'][$key] = [
                            'S' => $value
                        ];
                    }
                }
                $result = $client->putItem($itemData);

                return [
                    'success' => true,
                    'message' => 'Registered Successfully',
                    'id'      => $autoIncrementId
                ];

            }
            else
            {
                
                $items = $result->get('Items');
                //print_r($items);die;
                $itemData = [
                    'Item' => [
                        'id' => [
                            'N' => (string)$items[0]['id']['N'],
                        ],
                        'shop_id' => [
                            'N' => (string)$shop['_id'],
                        ],
                        'app_id' => [
                            'N' => (string)$appConfig['_id'],
                        ],
                        'queue_reference_id' => [
                            'S' => (string)$data['queue_unique_id'],
                        ],
                        'topic' => [
                            'S' => (string)$data['topic']
                        ],
                        'queue_name' => [
                            'S' => (string)$data['queue_name']
                        ],
                        // 'address' => [
                        //     'S' => (string)$address
                        // ],
                        'queue_data' => [
                            'S' => (string)json_encode($queueData)
                        ]
                    ],
                    'TableName' => 'webhook_config', // REQUIRED
                ];
                if(isset($data['other_unique_ids'])) {
                    
                    foreach($data['other_unique_ids'] as $key => $value){
                        $itemData['Item'][$key] = [
                            'S' => (string)$value
                        ];
                    }
                }

                //print_r($itemData);die;
                $result = $client->putItem($itemData);
                return [
                    'success' => true,
                    'message' => 'Already Registered',
                    'code' => 'already_registered',
                    'id'    => $items[0]['id']['N'],
                    'queue_data' => $queueData
                ];
            }
        }
        catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    public function getQueueBaseUrl($queue_url)
    {
        $explode = explode('/', $queue_url);
        unset($explode[count($explode)-1]);

        return implode('/', $explode);
    }

    public function getApiMode($request_data)
    {
        if(isset($request_data['sandbox']) && $request_data['sandbox']) $mode = 'sandbox';
        else $mode = 'live';

        return $mode;
    }

    public function getWebhookAddress($queryParams,$endpoint)
    {
        

        return $endpoint.'?'. http_build_query($queryParams);
    }


    public function deleteSigleConfig($data)
    {
        try {
            $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

            $shop = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $result = $client->scan([
                'FilterExpression' => "shop_id=:shop_id AND app_id=:app_id AND topic=:topic",
                "ExpressionAttributeValues" => [
                    ":shop_id" => [
                        'N' => (string)$shop['_id']
                    ],
                    ":app_id" => [
                        'N' => (string)$appConfig['_id']
                    ],
                    ":topic" => [
                        'S' => (string)$data['topic']
                    ]
                ],
                'TableName' => 'webhook_config', // REQUIRED
            ]);
            
           
            if($result->get('Count') > 0)
            {
                foreach($result->get('Items') as $item) {
                      $result = $client->deleteItem([
                        'Key' => [ 
                            'id' => [
                                'N' => (string)$item['id']['N'],
                            ]
                        ],
                        'TableName' => 'webhook_config', // REQUIRED
                    ]);  
                }

                return [
                    'success' => true,
                    'message' => 'Unegistered Successfully',
                ];

            }
            else
            {
                return [
                    'success' => true,
                    'message' => 'Already Unregistered',
                    'code' => 'already_unregistered'
                ];
            }
        }
        catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    public function deleteAllConfig()
    {
        try {
            $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');

            $shop = $this->di->getRegistry()->getCurrentShop();
            $appConfig = $this->di->getRegistry()->getAppConfig();

            $result = $client->scan([
                'FilterExpression' => "shop_id=:shop_id AND app_id=:app_id",
                "ExpressionAttributeValues" => [
                    ":shop_id" => [
                        'N' => (string)$shop['_id']
                    ],
                    ":app_id" => [
                        'N' => (string)$appConfig['_id']
                    ]
                ],
                'TableName' => 'webhook_config', // REQUIRED
            ]);
            
           
            if($result->get('Count') > 0)
            {
                foreach($result->get('Items') as $item) {
                      $result = $client->deleteItem([
                        'Key' => [ 
                            'id' => [
                                'N' => (string)$item['id']['N'],
                            ]
                        ],
                        'TableName' => 'webhook_config', // REQUIRED
                    ]);  
                }

                return [
                    'success' => true,
                    'message' => 'Unegistered Successfully',
                ];

            }
            else
            {
                return [
                    'success' => true,
                    'message' => 'Already Unregistered',
                    'code' => 'already_unregistered'
                ];
            }
        }
        catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }
}