<?php

namespace App\Apiconnect\Components;

use Phalcon\Events\Event;
use \App\Core\Middlewares\Firewall as BaseFirewall;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Firewall extends BaseFirewall
{
    /**
     * @var int
     */
    public $timeLimit = 60;

    /**
     * @var int
     */
    public $throttleLimit = 50;

    /**
     * Before anything happens
     * @param Event $event
     * @param \Phalcon\Mvc\Application $application
     * @return bool
     */
    public function beforeHandleRequest(Event $event, \Phalcon\Mvc\Application $application)
    {
        $this->di = $application->di;
        $headers = $this->get_nginx_headers();
        $token = $application->di->getRegistry()->getDecodedToken();
        /*print_r($headers);
        print_r($token);
        print_r($application->request->get());die;
        */
        $subAppId = false;//$application->di->get('session')->get('sub_app_id');
        if (isset($token['sub_app_id'])) {
            $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');
            $subAppConfig = $appsModel->getSubConfig($token['sub_app_id']);
            $application->di->getRegistry()->setAppConfig($subAppConfig);
        } elseif (isset($headers['sAppId']) || $application->request->get('sAppId')) {
            if($subAppId){
                
                $sAppId = $subAppId;
            }
            else{
                $sAppId = $headers['sAppId'] ?? $application->request->get('sAppId');    
            }

            $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');
            $subAppConfig = $appsModel->getSubConfig($sAppId);
            $application->di->getRegistry()->setAppConfig($subAppConfig);
        } elseif (isset($token['app_id'])) {
            $appConfig = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')
                            ->getConfig($token['app_id']);
            $application->di->getRegistry()->setAppConfig($appConfig);
        } elseif (isset($headers['appId']) || $application->request->get('appId')) {
            $appId = $headers['appId'] ?? $application->request->get('appId');
            $appConfig = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps')
                        ->getConfig($appId);
            $application->di->getRegistry()->setAppConfig($appConfig);
        } else {
            $application->di->getRegistry()->setAppConfig(false);
        }

        if ($state = $application->request->get('state')) {
            $state = $application->di->getObjectManager()->get('App\Core\Components\Helper')
                        ->decodeToken($state, false);
            
            if (isset($state['success']) && $state['success']) {
                $state = $state['data'];
                $appsModel = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps');
               
                if (isset($state['sub_app_id'])) {
                    $subAppConfig = $appsModel->getSubConfig($state['sub_app_id']);
                    $application->di->getRegistry()->setAppConfig($subAppConfig);
                } elseif (isset($state['app_id'])) {
                    $appConfig = $appsModel->getConfig($state['app_id']);
                    $application->di->getRegistry()->setAppConfig($appConfig);
                }
                $application->di->getRegistry()->setAppState($state);
                return true;
            } else {
                $application->di->getRegistry()->setAppState(false);
            }
        } else {
            $application->di->getRegistry()->setAppState(false);
        }

        $shopId = $application->request->get('shop_id')? $application->request->get('shop_id'):$application->request->getPut('shop_id');


        if ($application->di->getRegistry()->getAppConfig() && $shopId) {

            $shop = $application->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                        ->getById($shopId);
            
            $application->di->getRegistry()->setCurrentShop($shop);
        } else {
            $application->di->getRegistry()->setCurrentShop(false);
        }
        return true;
    }

}
