<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Ebaywebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Apiconnect\Components;

use \App\Core\Components\Base as CoreBase;

/**
 * Class Base
 * @package App\Code\Apiconnect\Components
 */
class Base extends CoreBase
{
    /**
     * @param $appConfig
     * @return mixed
     */
    public function getCredentials($sandbox = false)
    {
        $appConfig = $this->di->getRegistry()->getAppConfig();
        if (!$sandbox) {
            $appConfig['live']['sandbox'] = false;
            $appConfig['live']['debug'] = false;
            return $appConfig['live'];
        } else {
            $appConfig['sandbox']['debug'] = false;
            $appConfig['sandbox']['sandbox'] = true;
            return $appConfig['sandbox'];
        }
    }
}