<?php

namespace App\Apiconnect\Components\Authenticate;

use App\Apiconnect\Components\Base;

/**
 * Class Common
 * @package App\Apiconnect\Components\Authenticate
 */
class Common extends Base
{
    /**
     * @param array $stateToken
     * @return mixed
     */
    public function getStateToken($stateToken = []){
        $date1 = new \DateTime('+5 minute');
        $token = [
            "exp" => $date1->getTimestamp()
        ];
        $config = $this->di->getRegistry()->getAppConfig();

        if (isset($config['_id']))
            $token["app_id"] = $config['_id'];

        if ($state = $this->di->getRequest()->get('state')) {
            $token["app_state"] = $this->di->getRequest()->get('state');
        }
        if (isset($config['sub_app_id']))
            $token["sub_app_id"] = $config['sub_app_id'];
        $token = array_merge($token,$stateToken);
        return $this->di->getObjectManager()->get('App\Core\Components\Helper')->getJwtToken($token,'RS256',false);
    }

    /**
     * @return mixed
     */
    public function getAppState(){
        return $this->di->getRegistry()->getAppState();
    }

    /**
     * @param $baseUrl
     * @param $path
     * @param $params
     * @return string
     */
    public function getUrl($baseUrl,$path,$params){
        $uris = explode('?',$baseUrl);
        $baseUrl = $uris[0];
        if ($state = $this->getAppState()) {
            $params['state'] = $state['app_state'] ?? '';
        }
        if (isset($uris[1])) {
            $params = $uris[1].'&'.http_build_query($params);
        } else {
            $params = http_build_query($params);
        }

        return $baseUrl.$path.'?'.$params;
    }

    /**
     * @param null $baseUrl
     * @return \GuzzleHttp\Psr7\Uri
     */
    public function getBaseUri($baseUrl = null){
        return new \GuzzleHttp\Psr7\Uri($baseUrl);
    }
}