<?php

namespace App\Apiconnect\Api\Request;

/**
 * Class Base
 * @package App\Apiconnect\Api
 */
class Base extends \App\Apiconnect\Api\Base
{
    /**
     * Validate Request
     *
     * @param mixed $request request object.
     * @return false/object of marketplace specific product component
     */
    public function getComponent() {
        if ($appConfig = $this->di->getRegistry()->getAppConfig()) {
            $marketplace = $this->di->getConfig()->get('marketplace-modules')
                            ->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);
            if(class_exists('\App\\'.$marketplace.'\Api\Request\\'.$this->_component)){
                return $this->di->getObjectManager()->get('\App\\'.$marketplace.'\Api\Request\\'.$this->_component);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * @param $name
     * @param $arguments
     * @return array|mixed
     */
    public function __call($name, $arguments)
    {
        try {
            if ($component = $this->getComponent()) {
                if (method_exists($component, $name)) {
                    return call_user_func_array(array($component, $name), $arguments);
                }
            }
            return $arguments[0];
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Something went wrong', 'code' => 'something_went_wrong_in_call'];
        }
    }

}
