<?php

namespace App\Apiconnect\Api;

class Apps extends \App\Apiconnect\Api\Base
{

    /**
     * Create the Apps
     *
     * @param array/json $request 
     * @return array/json with success true/false and message
     */
    public function create($request)
    {
        try {
            $request = $this->di->getRequest();
            $contentType = $request->getHeader('Content-Type');
            if (strpos($contentType, 'application/json') !== false) {
                $data = $request->getJsonRawBody(true);
            } else {
                $data = $request->get();
            }
            if (isset($data['_url'])) {
                unset($data['_url']);
            }
            $model = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
            $data['_id'] = $model->getCounter('apps_id');
            
            $helper = $this->di->getObjectManager()->get('\App\Core\Components\Helper');
            $keys = $helper->getKeyPair();
            $data['public_key'] = $keys['public'];
            $data['private_key'] = $keys['private'];
            $model->setData($data);
            $response = $model->save();
            if ($response) {
                return ['success' => true, 'message' => 'App created Successfuly'];
            } else {
                return ['success' => false, 'message' => 'App creation failed', 'code' => 'apps_create_error'];
            }
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Something wrong in apps creation', 'code' => 'apps_create_error'];
        }
    }

    /**
     * Delete the Apps
     *
     * @param array/json $reques
     * @return array/json with success true/false and message
     */
    public function delete($request)
    {
        try {
            $request = $this->di->getRequest();
            $model = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
            $collection = $model->getCollection();
            if ($request->get('id')) {
                $result = $collection->deleteOne(['_id' => (int)$request->get('id')]);
                return ['success' => true, 'message' => 'App deleted Successfuly..'];
            } else {
                return ['success' => false, 'message' => 'No Record Matched', 'code' => 'no_record_found'];
            }
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Something wrong in apps delete', 'code' => 'apps_delete_error'];
        }
    }

    /**
     * get current request app config.
     *
     * @param $params
     * @return array
     */
    public function getAppConfig($params){
        return $this->di->getRegistry()->getAppConfig();
    }
    /**
     * get one Apps/ get Apps list.
     *
     * @param array/json $request
     * @return array/json with success true/false and message
     */
    public function get($data)
    {
        try {
            $model = $this->di->getObjectManager()->get('App\Apiconnect\Models\Apps');
            if($this->di->getRegistry()->getIsSubUser() && $this->di->getSubUser()){
                $userData = $this->di->getSubUser();
                $collection = $model->getCollection();
                $aggregation = [];
                $aggregation[] = [
                    '$lookup'=> [
                        'from'=> 'sub_user',
                        'localField'=> "_id",    // field in the sub_user collection
                        'foreignField'=> "apps.app_id",  // field in the apps collection
                        'as'=> "subUsers"
                    ]
                ];
                $aggregation[] = ['$unwind'=>'$subUsers'];
                $aggregation[] = ['$unwind'=>'$subUsers.apps'];
                $aggregation[] = ['$addFields'=>['sub_app_id' => '$subUsers.apps.app_id']];
                if (isset($data['id'])) {
                    $aggregation[] = ['$match' =>
                        [
                            '$and'=>[
                                ['_id' => (int)$data['id']],
                                ['subUsers._id' => $userData['_id']]
                            ]
                        ]
                    ];
                    $response = $collection->aggregate($aggregation)->toArray()[0] ?? [];
                } else {
                    $aggregation[] = ['$match' =>
                        ['subUsers._id' => ['$eq'=> $userData['_id']]
                        ]];
                    $response = $collection->aggregate($aggregation)->toArray();
                }

                $temp = [];
                foreach ( $response as $key => $val ) {
                    if ( $val['_id'] == $val['sub_app_id']) {
                        $temp[] = $val;
                    }
                }
                $response = $temp;
            } else {
                if (isset($data['id'])) {
                    $response = $model->getConfig($data['id']);
                } else {
                    $collection = $model->getCollection();
                    $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
                    $response = $collection->find($data['filter'] ?? [], $options)->toArray();
                }
            }
            return ['success' => true, 'data' => $response];
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Something wrong in apps get process', 'code' => 'apps_get_error'];
        }
    }

    /**
     * Create/update the Apps
     *
     * @param array/json $request 
     * @return array/json with success true/false and message
     */
    public function update($data)
    {
        try {
            $request = $this->di->getRequest();
            $contentType = $request->getHeader('Content-Type');
            if (strpos($contentType, 'application/json') !== false) {
                $data = $request->getJsonRawBody(true);
            } else {
                $data = $request->get();
            }
            if (isset($data['_url'])) {
                unset($data['_url']);
            }
            
            $model = $this->di->getObjectManager()->get('App\Apiconnect\Models\Apps');
            $collection = $model->getCollection();
            if (isset($data['id'])) {
                $id = $data['id'];
                unset($data['id']);
                //$data['_id'] = $id;
                //print_r($data);die;
                
                $response = $collection->updateOne(['_id' => (int)$id], ['$set' =>$data]);
                if ($response->getMatchedCount()) {
                    return ['success' => true, 'message' => 'App Updated Successfuly'];
                } else {
                    return ['success' => false, 'message' => 'No Record Matched', 'code' => 'no_record_found'];
                }
            } else {
                $data['_id'] = $model->getCounter('apps_id');
                $model->setData($data);
                $response = $model->save();
                if ($response) {
                    return ['success' => true, 'message' => 'App created Successfuly'];
                } else {
                    return ['success' => false, 'message' => 'App creation failed', 'code' => 'apps_create_error'];
                }
            }
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Something went wrong', 'code' => 'product_update_error'];
        }
    }
}
