# Profile API

## Get profiles of all users

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getUserProfiles();
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    die;

//    Sample Response : {"success":true,"data":[{"userId":"e8beb630-25fe-4980-abc9-a3ee1f7b5d2d","attributes":{"contactBookVersionId":{"stringValue":"1"},"defaultShippingAddressId":{"stringValue":"720819f3995f4a72bc0c1e8d6c8283fe"},"contactBookId":{"stringValue":"98029975-8f2a-99ec-7251-78g2f9ecd7a2"}}}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get profiles of single user

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getUserProfile(
        [
            'params' => [
                'userId' => 'e8beb630-25fe-4980-abc9-a3ee1f7b5d2d'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    die;

//    Sample Response : {"success":true,"data":{"userId":"e8beb630-25fe-4980-abc9-a3ee1f7b5d2d","attributes":{"contactBookVersionId":{"stringValue":"1"},"defaultShippingAddressId":{"stringValue":"720819f3995f4a72bc0c1e8d6c8283fe"},"contactBookId":{"stringValue":"98029975-8f2a-99ec-7251-78g2f9ecd7a2"}}}}
    
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Update a user profile

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->updateUserProfile(
        [
            'params' => [
                'userId' => 'e8beb630-25fe-4980-abc9-a3ee1f7b5d2d'
            ],
            'data' => [
                "attributes" => [
                    [
                        "attributeName" => "contactBookId",
                        "attributeValue" => [
                            "stringValue" => "98029975-8f2a-99ec-7251-78g2f9ecd7a2"
                        ]
                    ],
                    [
                        "attributeName" => "contactBookVersionId",
                        "attributeValue" => [
                            "stringValue" => "1"
                        ]
                    ],
                    [
                        "attributeName" => "defaultShippingAddressId",
                        "attributeValue" => [
                            "stringValue" => "189 Gomti Nagar"
                        ]
                    ]
                ]
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    die;

//    Sample Response : {"success":true,"data":{"message":"Profile updated successfully"}}
    
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```