# Place API

## Get place 

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getPlace(
        [
            'params' => [
                'placeId' => '720819f3995f4a72bc0c1e8d6c8283fe'
            ]
        ]
    );
    echo '<pre>';
    print_r($apiObj->getLastResponseHeaders());
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":{"placeId":"720819f3995f4a72bc0c1e8d6c8283fe","placeType":"shipping-address","place":{"streetName":"Terry Ave N","streetAddress":"410 Terry Ave N","countryCode":"US","postalCode":"98109","locality":"Seattle","buildingNumber":"410","region":"WA","contactDetails":{"name":"John Smith","contactNumber":"(206)555-1234"}}}}
    
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Create Place

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createPlace(
        [
            'data' => array(
                'placeType' => 'billing-address',
                'place' =>
                    array(
                        'streetAddress' => '189',
                        'streetName' => 'Aminabad',
                        'buildingNumber' => '20',
                        'postalCode' => '226018',
                        'locality' => 'Seattle',
                        'region' => 'WA',
                        'countryCode' => 'IN',
                        'contactDetails' =>
                            array(
                                'name' => 'Shivam Verma',
                                'contactNumber' => '8808287284',
                            ),
                    ),
            )
        ]
    );
    echo '<pre>';
    print_r($apiObj->getLastResponseHeaders());
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":{"placeId":"vLObeQJWrp"}}
    
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```