# Order API


## Get an order ids 

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getOrderIds();
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    Sample Response : {"success":true,"data":[{"orderId":"61addaab-7b67-416d-b60d-78a1dfd2807c"},{"orderId":"f4a1b3ff-b358-4069-b308-94bdac505c58"},{"orderId":"69449970-4580-42c4-85c7-c91f640d50b8"},{"orderId":"46085b78-a3cc-4384-a7ae-345f54c979c6"},{"orderId":"abb2e10a-ae97-44d6-823a-73056d78f280"},{"orderId":"208adc27-f2aa-47d5-b2be-ca8f90422cec"},{"orderId":"6ec9881c-935f-4bd5-88ad-2454e7fe867c"},{"orderId":"c7bd7701-8f75-4f75-ae2b-2bf5524544b4"},{"orderId":"3e3f7687-6f7a-46c6-ba58-8e462044ba26"},{"orderId":"0978cc93-a9fc-40ec-866c-44b27bee4967"},{"orderId":"a96318a2-2672-4def-b1f6-ec12a62cde8a"},{"orderId":"fa3e8dc2-3917-47e5-906d-7f0164b55b6e"},{"orderId":"d3fb2c59-b908-46da-90db-4f3dc3fca1e1"},{"orderId":"c231c08b-62f6-42bc-8734-56fcbe61b332"},{"orderId":"eef821c1-9be0-42fe-8e78-0cc8a566a352"},{"orderId":"4708fd16-5f70-41aa-a3c0-cd0a066e1f7f"},{"orderId":"c1d08117-4047-407b-a691-ad067c014f08"},{"orderId":"f1d14dd0-0360-4181-8252-549e620a25cd"},{"orderId":"af6cce8e-b24a-488a-8004-69e0fb6a1c6c"}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>

```

## Get an order details

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $order_id = '61addaab-7b67-416d-b60d-78a1dfd2807c';
    $response = $apiObj->getOrder(
        [
            'params' => [
                'order_id' => $order_id
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"payments":[{"paymentMethodArn":"1h9pp13vp891q0s2swd1f0ld","confirmationDate":"1635261527024","amount":{"start":"0","unit":"USD","measure":"28.65"},"paymentNetworkId":"2yxrvl420yyxz7ebf0c8d6j4","baseId":"4v24qroyv3ub7v988hc7w55r","source":"f120323c-204f-4438-b0fe-9ae943a34ecd","state":"CAPTURED","paymentMethodType":"PaymentMethod"}],"salesTaxes":[{"collectableTaxAmount":{"start":"0","unit":"USD","measure":"2.66"},"taxableAmount":{"start":"0","unit":"USD","measure":"25.99"},"taxRate":"0.1025","taxNexus":"DESTINATION","jurisdictionDetails":{"rate":{"countyTaxRate":"0.003","cityTaxRate":"0.0115","stateTaxRate":"0.065","districtTaxRate":"0.023"},"level":{"county":"KING","city":"SEATTLE","stateCode":"WA"},"amount":{"cityTaxableAmount":{"start":"0","unit":"USD","measure":"25.99"},"stateTaxableAmount":{"start":"0","unit":"USD","measure":"25.99"},"countyTaxableAmount":{"start":"0","unit":"USD","measure":"25.99"},"countyTaxCollectableAmount":{"start":"0","unit":"USD","measure":"0.08"},"districtTaxCollectableAmount":{"start":"0","unit":"USD","measure":"0.6"},"stateTaxCollectableAmount":{"start":"0","unit":"USD","measure":"1.69"},"cityTaxCollectableAmount":{"start":"0","unit":"USD","measure":"0.3"},"districtTaxableAmount":{"start":"0","unit":"USD","measure":"25.99"}}},"taxCalculationSource":"TAX_JAR","collectableTaxAmountPerUnit":{"start":"0","unit":"USD","measure":"2.66"},"id":"9b6db6c1f8-9fb7404b2b-sales-tax"}],"summary":{"rollupCharges":[{"rollupChargeType":"ORDER_SUB_TOTAL","relationships":{"charges":[{"id":"charge:9b6db6c1f8-9fb7404b2b:PRINCIPAL:PRICE"}]},"value":{"unit":"USD","measure":"25.99"}},{"rollupChargeType":"ORDER_SHIPPING","relationships":{"charges":[{"id":"charge:Standard (3-5 business days):PRINCIPAL:SHIPPING"}]},"value":{"start":"1.00","unit":"USD","measure":"0.00"}},{"rollupChargeType":"ORDER_TAX","relationships":{"charges":[{"id":"charge:Standard (3-5 business days)-sales-tax:TAX:SHIPPING"},{"id":"charge:9b6db6c1f8-9fb7404b2b:TAX:PRICE"}]},"value":{"start":"0","unit":"USD","measure":"2.66"}}],"totalPrice":{"start":"0","unit":"USD","measure":"28.65"}},"contacts":[{"contact":{"contactBookVersionId":"1","contactBookManagerId":"25e15af7-10fb-4f96-bc31-2d3353531414","contactBookId":"01825ca4-568d-41b5-8fd3-a0a35ae899fa"},"id":"01825ca4-568d-41b5-8fd3-a0a35ae899fa"}],"addresses":[{"id":"3e76544788a04857b29c7c83ab86f050","place":{"placeId":"3e76544788a04857b29c7c83ab86f050","placeInstanceId":"4a3c58687c944914ab5a24ed9f6f1fff"}},{"providedBy":"Payment","id":"3e76544788a04857b29c7c83ab86f050","place":{"placeId":"3e76544788a04857b29c7c83ab86f050","placeInstanceId":"4a3c58687c944914ab5a24ed9f6f1fff"}}],"orderUnits":[{"quantity":{"start":"0","unit":"ONE","measure":"1"},"baseId":"9b6db6c1f8","id":"9b6db6c1f8-9fb7404b2b","createDate":"1635261225258"}],"deliveryGroups":[{"relationships":{"orderUnit":[{"id":"9b6db6c1f8-9fb7404b2b"}]},"fulfillmentProvider":"SELF_FULFILLMENT","id":"delivery-group-1"}],"actors":[{"relationships":{"shippingAddress":[{"id":"3e76544788a04857b29c7c83ab86f050"}],"orderUnit":[{"id":"9b6db6c1f8-9fb7404b2b"}]},"role":"RECIPIENT","id":"03e6680f-ef55-48d8-9b76-f62302b56fa7"},{"relationships":{"shippingAddress":[{"id":"3e76544788a04857b29c7c83ab86f050"}],"contact":[{"id":"01825ca4-568d-41b5-8fd3-a0a35ae899fa"}],"orderUnit":[{"id":"9b6db6c1f8-9fb7404b2b"}]},"role":"PAYER","id":"id-AF4T32P7JLSQD6R4E2GAMC67NVOA"},{"relationships":{"contact":[{"id":"01825ca4-568d-41b5-8fd3-a0a35ae899fa"}],"orderUnit":[{"id":"9b6db6c1f8-9fb7404b2b"}]},"role":"SHOPPER","id":"f120323c-204f-4438-b0fe-9ae943a34ecd"}],"shipmentTransfers":[{"revisionId":"8","relationships":{"orderUnit":[{"interval":{"start":"0","measure":"1"},"id":"9b6db6c1f8-9fb7404b2b"}]},"fulfillmentId":"Pntl6F9bWCnh","fulfillmentManagerId":"hpcqx4em982q","fulfillmentOrderId":"BCIyizjnYD2K","trackingDetail":{"latestStatusCode":"DELIVERED","latestStatusSubCode":"DELIVERED_001","latestUpdateTimestamp":"1635793704000000","carrierCode":"usps","trackingId":"9361289674006772293724"},"fulfiller":"MERCHANT","id":"6c60f0ab-ffda-498c-ae80-a50028b051c9","state":"FULFILLED"}],"items":[{"regularPrice":"25.99","description":"description","title":"title","itemId":"1fxedizb7fo8v","relationships":{"orderUnit":[{"interval":{"start":"0","measure":"1"},"id":"9b6db6c1f8-9fb7404b2b"}]},"catalogId":"bbbmmm111","price":"25.99","variations":[],"fulfilledBy":"Merchant","imageUrl":"https:\/\/cdn.url\/6pn3xq5xg\/einlnmlbd\/B07S1CTLCP.MAIN.1.1.1.jpg","arn":"arn:aws:service:us-east-1:123123123123:catalogs\/bbbmmm111\/items:1fxedizb7fo8v:1635482976528","sku":"B07S1CTLCP","currencyCode":"USD"}],"deliveryItems":[{"itemId":"1fxedizb7fo8v","relationships":{"deliveryGroup":[{"id":"delivery-group-1"}]},"badge":"NONE","id":"delivery-item-1-0"}],"contractState":{"state":"SIGNED"},"orderState":{"initiatedDate":"1635261225260","placementDate":"1635261536393","createDate":"1635261536393"},"buyingApplication":{"browserFingerprint":{"browserPlatform":"desktop","browserTimezone":"America\/Chicago","browserVersion":"94.0.4606.81","browserType":"Chrome"},"storeFingerprint":{"storeUrl":"store.url"},"checkoutSession":{"identityContext":{"sessionId":"42d8bcfb-ee05-47be-af79-06c5d022cb2f","userType":"Guest"},"sessionId":"42d8bcfb-ee05-47be-af79-06c5d022cb2f"}},"deliveryOptionSelections":[{"deliveryOptionId":"Standard (3-5 business days)","relationships":{"orderUnit":[{"id":"9b6db6c1f8-9fb7404b2b"}]},"id":"delivery-option-selection-1"}],"orderIdentifier":{"orderId":"61addaab-7b67-416d-b60d-78a1dfd2807c","contractDefinitionId":"contractDefinitionId","orderManagerId":"orderManagerId"},"deliveryOptions":[{"relationships":{"deliveryGroup":[{"id":"delivery-group-1"}]},"deliveryOptionTransfer":{"deliveryDate":{"latestEpochMilliseconds":"1635693525340","earliestEpochMilliseconds":"1635693525340"},"shipDate":[],"deliveryOptionName":"Standard (3-5 business days)"},"fulfillmentFee":{"money":{"start":"1","unit":"USD","measure":"0.0"}},"shippingCharge":{"money":{"start":"1","unit":"USD","measure":"0.0"}},"isFree":false,"deliveryOptionId":"Standard (3-5 business days)"},{"relationships":{"deliveryGroup":[{"id":"delivery-group-1"}]},"deliveryOptionTransfer":{"deliveryDate":{"latestEpochMilliseconds":"1635693525340","earliestEpochMilliseconds":"1635693525340"},"shipDate":[],"deliveryOptionName":"Expedited (1-2 business days)"},"fulfillmentFee":{"money":{"start":"1","unit":"USD","measure":"4.99"}},"shippingCharge":{"money":{"start":"1","unit":"USD","measure":"4.99"}},"isFree":false,"deliveryOptionId":"Expedited (1-2 business days)"}]}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```