# Event API

## Create Event API

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createEvent(
        [
            'params' => [
                "event" => "order",
                "event-type" => "order_placed"
            ]
        ]
    );
    echo '<pre>';
    print_r($apiObj->getLastResponseHeaders());
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":{"FailedEntryCount":0,"Entries":[{"EventId":"03e1d350-bf1e-d18a-0c54-40aa0dbc8896"}],"ResponseMetadata":{"RequestId":"79c575ba-c8e3-4606-8e64-78c4874658c7","HTTPStatusCode":200,"HTTPHeaders":{"x-amzn-requestid":"79c575ba-c8e3-4606-8e64-78c4874658c7","content-type":"application\/x-amz-json-1.1","content-length":"85","date":"Tue, 04 Jan 2022 08:11:46 GMT"},"RetryAttempts":0}}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```