# Domains API

## Get all created domains

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getDomains();
    echo '<pre>';
    print_r($apiObj->getLastResponseHeaders());
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":[{"systemGenerated":"true","domainGroupId":"dg-123456","domain":"myawesomestore.co.uk"},{"systemGenerated":"false","domainGroupId":"dg-123456","domain":"myawesomestore.co.us"},{"systemGenerated":"false","domainGroupId":"dg-123456","domain":"myawesomestore.com"},{"systemGenerated":"false","domainGroupId":"dg-678456","domain":"mystore-sports.santos.com"},{"systemGenerated":"true","domainGroupId":"dg-098765","domain":"mystore-acb42d.santos.com"},{"systemGenerated":"false","domainGroupId":"dg-098765","domain":"mystore-acb42d.santos.org"}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```