# Category API

## Get multiple categoryies from Onyx on the basis of category_set_id

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $categorySetId = 'gwD2u2hXHJw2';
    $response = $apiObj->getCategories(
        [
            'params' => [
                'categorySetId' => $categorySetId
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    //Sample Response : {"success":true,"data":[{"parentIds":[],"attributes":{"category-media-source-url":"url1","category-meta-description":"metaDescription","category-name":"category name","category-description":"category description","category-media-alt-text":"alt1","category-url":"url","category-page-title":"pageTitle","category-sort":"sort"},"categorySetId":"gwD2u2hXHJw2","categoryId":"ZXWjWiuH0L","status":"PUBLISHED"},{"parentIds":[],"categoryId":"veTYrkYcEX","status":"PUBLISHED","resourceMetadata":{"arn":"arn:aws:service:us-east-1:33333333333:category-sets\/gwD2u2hXHJw2\/categories\/veTYrkYcEX"},"attributes":{"category-media-source-url":"url","category-meta-description":"metaDescriptionupdated","category-name":"updated name - updated","category-description":"description - updated","category-media-alt-text":"alt","category-url":"url","category-page-title":"pageTitle - updated","category-sort":"sort"},"categorySetId":"gwD2u2hXHJw2"}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get single category from Onyx on the basis of category_set_id and category_id

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getCategory(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'ZXWjWiuH0L'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    //Sample Response : {"success":true,"data":{"parentIds":[],"attributes":{"category-media-source-url":"url1","category-meta-description":"metaDescription","category-name":"category name","category-description":"category description","category-media-alt-text":"alt1","category-url":"url","category-page-title":"pageTitle","category-sort":"sort"},"categorySetId":"gwD2u2hXHJw2","categoryId":"ZXWjWiuH0L","status":"PUBLISHED"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Create a catgeory on Onyx

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createCategory(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
            ],
            'data' => [
                'status' => 'PUBLISHED',
                "attributes" => [
                    "category-name" => "category name",
                    "category-description" => "category description",
                    "category-page-title" => "category page title",
                    "category-sort" => "category sort",
                    "category-url" => "category url",
                    "category-meta-description" => "category meta description",
                    "category-media-source-url" => "category media source url",
                    "category-media-alt-text" => "category media alt text"
                ],
                "parentIds" => []
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    //Sample Response : {"success":true,"data":{"resourceMetadata":{"arn":"arn:aws:service:us-east-1:33333333333:category-sets\/gwD2u2hXHJw2\/categories\/MHK7p3BKgk"}}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Update a category on Onyx

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->updateCategory(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'MHK7p3BKgk',
            ],
            'data' => [
                'status' => 'PUBLISHED',
                "attributes" => [
                    "category-name" => "updated category name",
                    "category-description" => "updated category description",
                    "category-page-title" => "updated category page title",
                    "category-sort" => "updated category sort",
                    "category-url" => "updated category url",
                    "category-meta-description" => "updated category meta description",
                    "category-media-source-url" => "updated category media source url",
                    "category-media-alt-text" => "updated category media alt text"
                ],
                "parentIds" => []
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    //Sample Response : {"success":true,"data":{"resourceMetadata":{"arn":"arn:aws:service:us-east-1:33333333333:category-sets\/gwD2u2hXHJw2\/categories\/ib5b6UTxFC"}}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Delete a cateogory on Onyx

```php 

<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->deleteCategory(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'ib5b6UTxFC'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    //Sample Response : {"success":true,"data":null}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get all category membership

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getCategoryMemberships(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'ZXWjWiuH0L'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    //Sample Response : {"success":true,"data":[{"categoryItemId":"EIx8rufklq"},{"categoryItemId":"arn:aws:service:us-east-1:14245262222:catalogs\/YEzFjXRG3G\/items\/EIx8rufklq"}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get a single category membership

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getCategoryMembership(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'ZXWjWiuH0L',
                'categoryItemId' => 'EIx8rufklq'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    //Sample Response : {"success":true,"data":null}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Create a category membership

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createCategoryMembership(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'ZXWjWiuH0L'
            ],
            'data' => [
                'categoryItemId' => 'arn:aws:service:us-east-1:14245262222:catalogs/YEzFjXRG3G/items/EIx8rufklqs'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    //Sample Response : {"success":true,"data":null}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Delete a category membership 

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->deleteCategoryMembership(
        [
            'params' => [
                'categorySetId' => 'gwD2u2hXHJw2',
                'categoryId' => 'ZXWjWiuH0L',
                'categoryItemId' => 'EIx8rufklq'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    //Sample Response : {"success":true,"data":null}


} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```