<?php

require_once '../vendor/autoload.php';

$profiling = [];
$start = microtime(true);

//Creating a dynamic object for the product category
$category = '\Amazon\Sdk\Product\Category\Home';
/**
 * @var \Amazon\Sdk\Product\Category\Home
 */
$product = new $category('FurnitureAndDecor');
$product->clear(); // clear data from object if re using it.
$product->setId('123'); // Unique message identifier, product id preferred
$product->SKU = "123";
$product->ProductData_Home_ProductType_FurnitureAndDecor_Battery_BatterySubgroup_BatteryType = "battery_type_2/3A";
$product->ProductData_Home_ProductType_FurnitureAndDecor_Battery_BatterySubgroup_NumberOfBatteries = "1";
$product->ProductData_Home_ProductType_FurnitureAndDecor_ColorMap = "Red";
$product->DescriptionData_BulletPoint = "q123||ghjl||123||1456"; // for multiple values, || is the seperator
$product->DescriptionData_Title = "Test";
$product->DescriptionData_Description = "Test";
$product->unitOfMeasure_LengthUnitOfMeasure = "MM";
$product->DescriptionData_ItemDimensions_Length = "10.00";
$product->ProductData_Home_SeatHeight = "10.00";
$profiling['product_object_prepared'] = (microtime(true) - $start);

// Creating a envelope to add product
$evelope = new \Amazon\Sdk\Product\Envelope(
    'AU5LJQPL530RI',
    \Amazon\Sdk\Product\Common::MESSAGE_TYPE_PRODUCT
);
if ($product->isValid()) {
    $profiling['product_object_validated'] = (microtime(true) - $start);
    $evelope->addProduct($product); // Adding product to envelope,
    // a envelope can have multiple same type of object, inventory, price, etc.
    $profiling['product_object_added'] = (microtime(true) - $start);
}

print_r($product->getData());
print_r("Get Data \n");
$profiling['product_object_get_data'] = (microtime(true) - $start);

print_r($product->getError());
print_r("Get Error \n");
$profiling['product_object_get_error'] = (microtime(true) - $start);

print_r($product->validateXml());
print_r("Generate Xml \n");
$profiling['product_object_xml_validated'] = (microtime(true) - $start);

$generator = new \Amazon\Sdk\Generator();
print_r($generator->arrayToXml($evelope->getData())->__toString());
print_r("Data rendered \n");
$profiling['product_object_xml_rendered'] = (microtime(true) - $start);


//0.78583693504333 seconds
//@TODO variant attributes cannot be null
//@TODO Regex check validator add
//@TODO Check all attributes
//@TODO Conditinally depends attributes getData() remove
