<?php

/*
 * This script retrieves a list of orders from the store "myStore" and displays various bits of their info.
 */
$list = getAmazonOrders();
if ($list) {
    echo 'My Store Orders<hr>';
    foreach ($list as $order) {
        //these are AmazonOrder objects
        echo '<b>Order Number:</b> '.$order->getAmazonOrderId();
        echo '<br><b>Purchase Date:</b> '.$order->getPurchaseDate();
        echo '<br><b>Status:</b> '.$order->getOrderStatus();
        echo '<br><b>Customer:</b> '.$order->getBuyerName();
        $address=$order->getShippingAddress(); //address is an array
        echo '<br><b>City:</b> '.$address['City'];
        echo '<br><br>';
    }
}

/**
 * This function will retrieve a list of all unshipped MFN orders made within the past 24 hours.
 * The entire list of orders is returned, with each order contained in an AmazonOrder object.
 * Note that the items in the order are not included in the data.
 * To get the order's items, the "fetchItems" method must be used by the specific order object.
 */
function getAmazonOrders() {
    try {
        $config = new \Amazon\Sdk\Api\Config(
            [
                'sellerId' => 'AU5LJQPL530RI',
                'marketplaceId' => [ 0 => 'A21TJRUUN4KGV'],
                'accessKeyId' => 'AKIAIGWDV4YWY53QGLMQ',
                'secretKey' => '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',
                'serviceUrl' => 'https://mws.amazonservices.in/',
                'muteLog' => false
            ]
        );

        $logger = new \Monolog\Logger('AMAZON');
        $logger->pushHandler(
            new \Monolog\Handler\StreamHandler(
                '/opt/lampp/htdocs/amazon/amazon-sdk/amazon.log',
                \Monolog\Logger::DEBUG
            )
        );

        $amz = new \Amazon\Sdk\Api\Order\OrderList($config, $logger);
        $amz->setLimits('Modified', "- 24 hours"); //accepts either specific timestamps or relative times
        $amz->setFulfillmentChannelFilter("MFN"); //no Amazon-fulfilled orders
        $amz->setOrderStatusFilter(
            array("Unshipped", "PartiallyShipped", "Canceled", "Unfulfillable")
            ); //no shipped or pending orders
        $amz->setUseToken(); //tells the object to automatically use tokens right away
        $amz->fetchOrders(); //this is what actually sends the request
        return $amz->getList();
    } catch (Exception $ex) {
        echo 'There was a problem with the Amazon library. Error: '.$ex->getMessage();
    }
}

?>
