<?php

/*
 * This script retrieves a list of active feeds for the store "myStore" and display info on them.
 */
$list = getAmazonFeedStatus();
if ($list) {
    echo 'Feed Status Report<hr>';
    foreach ($list as $feed) {
        //these are arrys
        echo '<b>Feed ID:</b> '.$feed['FeedSubmissionId'];
        echo '<br><b>Type:</b> '.$feed['FeedType'];
        echo '<br><b>Date Sent:</b> '.$feed['SubmittedDate'];
        echo '<br><b>Status:</b> '.$feed['FeedProcessingStatus'];
        echo '<br><br>';
    }
}

/**
 * This function will retrieve a list of all items with quantity that was adjusted within the past 24 hours.
 * The entire list of items is returned, with each item contained in an array.
 * Note that this does not relay whether or not the feed had any errors.
 * To get this information, the feed's results must be retrieved.
 */
function getAmazonFeedStatus(){
    try {
        $config = new \Amazon\Sdk\Api\Config(
            [
                'sellerId' => 'AU5LJQPL530RI',
                'marketplaceId' => [ 0 => 'A21TJRUUN4KGV'],
                'accessKeyId' => 'AKIAIGWDV4YWY53QGLMQ',
                'secretKey' => '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',
                'serviceUrl' => 'https://mws.amazonservices.in/',
                'muteLog' => false
            ]
        );

        $logger = new \Monolog\Logger('AMAZON');
        $logger->pushHandler(
            new \Monolog\Handler\StreamHandler(
                '/opt/lampp/htdocs/amazon/amazon-sdk/amazon.log',
                \Monolog\Logger::DEBUG
            )
        );

        $amz = new \Amazon\Sdk\Api\Feed\FeedList($config, $logger);
        $amz->setTimeLimits('- 24 hours'); //limit time frame for feeds to any updated since the given time
        $amz->setFeedStatuses(array("_SUBMITTED_", "_IN_PROGRESS_", "_DONE_")); //exclude cancelled feeds
        $amz->fetchFeedSubmissions(); //this is what actually sends the request
        return $amz->getFeedList();
    } catch (Exception $ex) {
        echo 'There was a problem with the Amazon library. Error: '.$ex->getMessage();
    }
}


$feed = "<?xml version=\"1.0\"?>
<AmazonEnvelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"amzn-envelope.xsd\">
  <Header>
    <DocumentVersion>1.01</DocumentVersion>
    <MerchantIdentifier>AU5LJQPL530RI</MerchantIdentifier>
  </Header>
  <MessageType>Inventory</MessageType>
  <PurgeAndReplace>false</PurgeAndReplace>
  <Message>
    <MessageID>2047</MessageID>
    <OperationType>Update</OperationType>
    <Inventory>
      <SKU>handmade-wooden-jewelry-box</SKU>
      <Quantity>0</Quantity>
      <FulfillmentLatency>1</FulfillmentLatency>
    </Inventory>
  </Message>
  <Message>
    <MessageID>2048</MessageID>
    <OperationType>Update</OperationType>
    <Inventory>
      <SKU>handmade-wooden-plate</SKU>
      <Quantity>1</Quantity>
      <FulfillmentLatency>1</FulfillmentLatency>
    </Inventory>
  </Message>
</AmazonEnvelope>";

/**
 * This function will send a provided Inventory feed to Amazon.
 * Amazon's response to the feed is returned as an array.
 * This function is not actively used on this example page as a safety precaution.
 */
function sendInventoryFeed($feed) {
    try {
        $config = new \Amazon\Sdk\Api\Config(
            [
                'sellerId' => 'AU5LJQPL530RI',
                'marketplaceId' => [ 0 => 'A21TJRUUN4KGV'],
                'accessKeyId' => 'AKIAIGWDV4YWY53QGLMQ',
                'secretKey' => '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',
                'serviceUrl' => 'https://mws.amazonservices.in/',
                'muteLog' => false
            ]
        );

        $logger = new \Monolog\Logger('AMAZON');
        $logger->pushHandler(
            new \Monolog\Handler\StreamHandler(
                '/opt/lampp/htdocs/amazon/amazon-sdk/amazon.log',
                \Monolog\Logger::DEBUG
            )
        );

        $amz=new \Amazon\Sdk\Api\Feed($config, $logger);
        $amz->setFeedType(\Amazon\Sdk\Api\Feed::PRODUCT_INVENTORY); //feed types listed in documentation
        $amz->setFeedContent($feed); //can be either XML or CSV data; a file upload method is available as well
        $amz->submitFeed(); //this is what actually sends the request
        return $amz->getResponse();
    } catch (\Amazon\Sdk\Api\Exception\InvalidConfigValue $ex) {
        echo 'There was a problem with the credentials provided. Error: '.$ex->getMessage();
    } catch (Exception $ex) {
        echo 'There was a problem with the Amazon library. Error: '.$ex->getMessage();
    }
}

/**
 * This function will get the processing results of a feed previously sent to Amazon and give the data.
 * In order to do this, a feed ID is required. The response is in XML.
 */
function getFeedResult($feedId) {
    try {

        $config = new \Amazon\Sdk\Api\Config(
            [
                'sellerId' => 'AU5LJQPL530RI',
                'marketplaceId' => [ 0 => 'A21TJRUUN4KGV'],
                'accessKeyId' => 'AKIAIGWDV4YWY53QGLMQ',
                'secretKey' => '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',
                'serviceUrl' => 'https://mws.amazonservices.in/',
                'muteLog' => false
            ]
        );

        $logger = new \Monolog\Logger('AMAZON');
        $logger->pushHandler(
            new \Monolog\Handler\StreamHandler(
                '/opt/lampp/htdocs/amazon/amazon-sdk/amazon.log',
                \Monolog\Logger::DEBUG
            )
        );

        //feed ID can be quickly set by passing it to the constructor
        $amz = new \Amazon\Sdk\Api\Feed\Result($feedId, $config, $logger);
        $amz->setFeedId($feedId); //otherwise, it must be set this way
        $amz->fetchFeedResult();
        $amz->saveFeed('/opt/lampp/htdocs/amazon/amazon-sd/amazon.xml'); // optional
        return $amz->getRawFeed();
    } catch (Exception $ex) {
        echo 'There was a problem with the Amazon library. Error: '.$ex->getMessage();
    }
}


?>
