<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2019 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Tests\Order\Fulfillment;

use PHPUnit\Framework\TestCase;
use Amazon\Sdk\Order\Fulfillment\CarrierCode;

class CarrierCodeTest extends TestCase
{
    public function testSearch()
    {
        $samples = [
            "Chronoexpress" => "Chrono Express",
            "Chronopost" => "Chronopost",
            "Chronopostc18" => "Chronopost",
            "Chronopos" => "Chronopost",
        ];

        foreach ($samples as $input => $expected) {
            $actual = CarrierCode::search($input);
            $this->assertEquals($expected, $actual);
        }
    }

    public function testSearchNegative()
    {
        $samples = [
            "Chronoxpress" => null,
        ];

        foreach ($samples as $input => $expected) {
            $actual = CarrierCode::search($input);
            $this->assertEquals($expected, $actual);
        }
    }
}
