<?php

namespace Amazon\Sdk\Product;

class Relationship extends \Amazon\Sdk\Base
{

    const RELATION_TYPE_VARIATION = 'Variation';

    const RELATION_TYPES = [
        self::RELATION_TYPE_VARIATION
    ];

    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_RELATIONSHIP;
    }

    /**
     * Set Relationship Data
     * @param string $parentSku
     * @param array $childs
     */
    public function setData($parentSku, array $childs = [])
    {
        $relationship = [];
        $relationship[0]['ParentSKU'] = (string)$parentSku;
        foreach ($childs as $sku => $type) {
            if (!in_array($type, self::RELATION_TYPES)) {
                $type = self::RELATION_TYPE_VARIATION;
            }

            $relationship[]['Relation'] = [
                'SKU' => (string)$sku,
                'Type' => (string)$type
            ];
        }
        $this->data = $relationship;
    }
}