<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Mlibre
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2019 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product;

interface ProductInterface
{
    /**
     * CategoryInterface constructor.
     * @param $subCategory , Sub Category Name
     */
    public function __construct($subCategory);

    /**
     * Message type
     * @return string
     */
    public function getMessageType();

    /**
     * Getting unique id for the message, it is suggested to use product id.
     * @return string
     */
    public function getId();

    /**
     * Setting unique id for the message, it is suggested to use product id with profile id.
     * @param  string $id
     * @return boolean $unique
     * @return string
     */
    public function setId($id, $unique = false);

    /**
     * Getting Operation Type
     * @return string
     */
    public function getOperationType();

    /**
     * Setting Operation Type
     * @return void
     */
    public function setOperationType($operationType);

    /**
     * Get All Attributes
     *
     * @param array $params , ['minOccurs' => "1"] TODO: marketplaceId
     * @return array
     */
    public function getAttributes($params = []);

    /**
     * Get an Attribute
     *
     * @param $key
     * @return array
     */
    public function getAttribute($key);

    /**
     * Validate required attributes
     *
     * @return void
     */
    public function validateData();

    /**
     * Get errors with level, id wise indexed
     *
     * @param int $level
     * @return array
     */
    public function getError($level = null);

    /**
     * Set error with level
     *
     * @param string $key
     * @param string $value
     * @param int $level
     * @return array
     */
    public function setError($key, $value, $level);

    /**
     * Get sub attribute
     *
     * @param $key , Attribute path
     * @return boolean|array
     */
    public function getSubAttribute($key);

    /**
     * Get sub attribute for a category
     *
     * @return null|array
     */
    public function getSubAttributes();

    /**
     * Get sequnced data
     *
     * @return array
     */
    public function getData();

    /**
     * Check product validation
     * @return boolean
     */
    public function isValid();

    /**
     * Clear data
     *
     * @return mixed
     */
    public function clear();

    /**
     * Set Barcode Exemption
     * @param boolean $value
     */
    public function setBarcodeExemption($value);

    /**
     * Get Barcode Exemption
     * @return bool
     */
    public function getBarcodeExemption();

    /**
     * Get Parentage Attribute Key
     * @return string
     */
    public function getParentageAttribute();

    /**
     * Get VariationTheme Attribute Key
     * @return string
     */
    public function getVariationThemeAttribute();

    /**
     * Get a attribute value for a product
     * @param $key
     * @return string|null
     */
    public function get($key);
}
