<?php

namespace Amazon\Sdk\Product;

class Price extends \Amazon\Sdk\Base
{
    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_PRICE;
    }

    /**
     * Set Price Data
     * @param $sku
     * @param $price
     * @param string $currency
     */
    public function setData($sku, $price, $currency = \Amazon\Sdk\Marketplace::CURRENCY_CODE_DEFAULT)
    {
        $this->data[0]['SKU']['_attribute'] = [];
        $this->data[0]['SKU']['_value'] = (string)$sku;
        $this->data[1]['StandardPrice']['_attribute']['currency'] = (string)$currency;
        $this->data[1]['StandardPrice']['_value'] = (string)$price;
    }

    public function setSale(
        $price,
        $from = null,
        $to = null,
        $currency = \Amazon\Sdk\Marketplace::CURRENCY_CODE_DEFAULT
    ) {
        //Amazon Format 2013-05-22T06:32:49+05:30
        if (empty($from)) {
            $from = 'now';
        }
        $this->data[2]['Sale']['_value'][0]['StartDate'] = (string)$this->getDate($from);

        if (empty($to)) {
            $to = 'now +30 days';
        }
        $this->data[2]['Sale']['_value'][1]['EndDate'] = (string)$this->getDate($to);

        $this->data[2]['Sale']['_attribute'] = [];
        $this->data[2]['Sale']['_value'][2]['SalePrice']['_attribute']['currency'] = (string)$currency;
        $this->data[2]['Sale']['_value'][2]['SalePrice']['_value'] = (string)$price;
    }

    public function setMrp($price, $currency = \Amazon\Sdk\Marketplace::CURRENCY_CODE_DEFAULT)
    {
        $this->data[3]['MaximumRetailPrice']['_attribute']['currency'] = (string)$currency;
        $this->data[3]['MaximumRetailPrice']['_value'] = (string)$price;
    }

    public function setMap($price, $currency = \Amazon\Sdk\Marketplace::CURRENCY_CODE_DEFAULT)
    {
        $this->data[3]['MAP']['_attribute']['currency'] = (string)$currency;
        $this->data[3]['MAP']['_value'] = (string)$price;
    }

    public function setBusinessPrice($price)
    {
        $this->data[3]['BusinessPrice'] = (string)$price;
    }

    public function setMinSellerAllowedPrice($price, $currency = \Amazon\Sdk\Marketplace::CURRENCY_CODE_DEFAULT)
    {
        $this->data[3]['MinimumSellerAllowedPrice']['_attribute']['currency'] = (string)$currency;
        $this->data[3]['MinimumSellerAllowedPrice']['_value'] = (string)$price;
    }
}
