<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Sdk
 * @package     Cedcommerce_Amazon_sdk
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CedCommerce (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product;

interface CollectionInterface extends \Psr\Container\ContainerInterface
{
    const CATEGORY_LEVEL_ROOT = 0;
    const CATEGORY_LEVEL_CHILD = 1;

    /**
     * Get all categories data
     * @return array
     */
    public function getData();

    /**
     * Get Amazon Categories
     * @param int $level
     * @return array
     */
    public function getCategories($level = self::CATEGORY_LEVEL_ROOT);
}
