<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class ToysBaby
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/ToysBaby.xsd
 */
class ToysBaby extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_TOYS_AND_GAMES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BABY_PRODUCTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'ToysBaby';
        $this->data["ProductData_{$this->category}_ProductType"] = $subCategory;
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "ToysAndGames":
                $this->attributes = array_merge($this->attributes, $this->getToysAndGames());
                break;
            case "BabyProducts":
                $this->attributes = array_merge($this->attributes, $this->getBabyProducts());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * ToysBaby => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ToysBaby_";
        $common = [
            "{$i}MaterialType" => [
                "sequence" => "{$s}150",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}250",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}270",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getToysAndGames()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * ToysBaby => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ToysBaby_";

        $this->attributes = [
            "ProductData_ToysBaby_ProductType" => [
                "sequence" => "100\\10\\20\\10",
                "name" => "ToysAndGames",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $this->attributes;
    }

    public function getBabyProducts()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * ToysBaby => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ToysBaby_";

        $this->attributes = [
            "ProductData_ToysBaby_ProductType" => [
                "sequence" => "100\\10\\20\\10",
                "name" => "BabyProducts",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_ToysBaby_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
