<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Toys
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/Toys.xsd
 */
class Toys extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_TOYS_AND_GAMES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HOBBIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COLLECTIBLE_CARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COSTUME = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Toys';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Toys => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Toys_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Size",
                                "SizeColor",
                                "Style",
                                "Edition",
                            ],
                    ],
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        switch ($this->subCategory) {
            case "ToysAndGames":
                $this->attributes = array_merge($this->attributes, $this->getToysAndGames());
                break;

            case "Hobbies":
                $this->attributes = array_merge($this->attributes, $this->getHobbies());
                break;
            case "CollectibleCard":
                $this->attributes = array_merge($this->attributes, $this->getCollectibleCard());
                break;
            case "Costume":
                $this->attributes = array_merge($this->attributes, $this->getCostume());
                break;
        }

        $common = [
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}30\\10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "1",
                "dataType" => "boolean",
                "restriction" => [
                    "optionValues" => [
                        "true",
                        "false",
                    ]
                ]
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}30\\20",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "1",
                "dataType" => "boolean",
                "restriction" => [
                    "optionValues" => [
                        "true",
                        "false",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}30\\30\\10",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2/3A",
                        "battery_type_4/3A",
                        "battery_type_4/5A",
                        "battery_type_9v",
                        "battery_type_12v",
                        "battery_type_a",
                        "battery_type_a76",
                        "battery_type_aa",
                        "battery_type_aaa",
                        "battery_type_aaaa",
                        "battery_type_c",
                        "battery_type_cr123a",
                        "battery_type_cr2",
                        "battery_type_cr5",
                        "battery_type_d",
                        "battery_type_lithium_ion",
                        "battery_type_lithium_metal",
                        "battery_type_L-SC",
                        "battery_type_p76",
                        "battery_type_product_specific",
                        "battery_type_SC",
                    ],
                ],
                "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                    "sequence" => "{$s}20\\30\\20",
                    "name" => "NumberOfBatteries",
                    "minOccurs" => "0",
                    "dataType" => "positiveInteger",
                ],
            ],
            "{$i}AssemblyInstructions" => [
                "sequence" => "{$s}40",
                "name" => "AssemblyInstructions",
                "minOccurs" => "1",
                "dataType" => "normalizedString",
                "length" => "1:1500"
            ],
            "{$i}AgeRecommendation_MinimumManufacturerAgeRecommended" => [
                "sequence" => "{$s}50\\10",
                "name" => "MinimumManufacturerAgeRecommended",
                "minOccurs" => "1",
                "dataType" => "PositiveIntegerDimension",
                "attribute" => "{$i}MinimumManufacturerAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"
            ],
            "{$i}AgeRecommendation_MaximumManufacturerAgeRecommended" => [
                "sequence" => "{$s}50\\20",
                "name" => "MaximumManufacturerAgeRecommended",
                "minOccurs" => "1",
                "dataType" => "PositiveIntegerDimension",
                "attribute" => "{$i}MaximumManufacturerAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"
            ],
            "{$i}AgeRecommendation_MinimumMerchantAgeRecommended" => [
                "sequence" => "{$s}50\\30",
                "name" => "MinimumMerchantAgeRecommended",
                "minOccurs" => "1",
                "dataType" => "PositiveIntegerDimension",
                "attribute" => "{$i}MinimumMerchantAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"
            ],
            "{$i}AgeRecommendation_MaximumMerchantAgeRecommended" => [
                "sequence" => "{$s}50\\40",
                "name" => "MaximumMerchantAgeRecommended",
                "minOccurs" => "1",
                "dataType" => "PositiveIntegerDimension",
                "attribute" => "{$i}MaximumMerchantAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        // Overriding the required attribute
        $this->attributes['DescriptionData_TargetAudience'] = [
            'sequence' => '30\190',
            'name' => 'TargetAudience',
            'dataType' => 'StringNotNull',
            'minOccurs' => '1',
            'maxOccurs'=> '4'
        ];

        $this->attributes['DescriptionData_Manufacturer'] = [
            'sequence' => '30\150',
            'name' => 'Manufacturer',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    public function getToysAndGames()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Toys => 10
         * ProductType => 20
         * ToysAndGames => 10
         */
        $s = "100\\10\\20\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Toys_ProductType_ToysAndGames_";

        $attributes = [
            "ProductData_Toys_ProductType_ToysAndGames" => [
                "sequence" => "100\\10\\20\\10",
                "name" => "ToysAndGames",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Color" => [
                "sequence" => "{$s}50",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getHobbies()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Toys => 10
         * ProductType => 20
         * Hobbies => 20
         */
        $s = "100\\10\\20\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Toys_ProductType_Hobbies_";

        $attributes = [
            "ProductData_Toys_ProductType_Hobbies" => [
                "sequence" => "100\\10\\20\\20",
                "name" => "Hobbies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BrakeStyle" => [
                "sequence" => "{$s}100",
                "name" => "BrakeStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getCollectibleCard()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Toys => 10
         * ProductType => 20
         * CollectibleCard => 30
         */
        $s = "100\\10\\20\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Toys_ProductType_CollectibleCard_";

        $attributes = [
            "ProductData_Toys_ProductType_CollectibleCard" => [
                "sequence" => "100\\10\\20\\30",
                "name" => "CollectibleCard",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Genre" => [
                "sequence" => "{$s}50",
                "name" => "Genre",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CardNumber" => [
                "sequence" => "{$s}200",
                "name" => "CardNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CardType" => [
                "sequence" => "{$s}250",
                "name" => "CardType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getCostume()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Toys => 10
         * ProductType => 20
         * Costume => 40
         */
        $s = "100\\10\\20\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Toys_ProductType_Costume_";

        $attributes = [
            "ProductData_Toys_ProductType_Costume" => [
                "sequence" => "100\\10\\20\\40",
                "name" => "Costume",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}50",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Toys_";

        $subAttributes = self::SUB_ATTRIBUTES;

        $subAttributes["{$i}MinimumManufacturerAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "months",
                            "years",
                        ],
                ],
            "default" => "months"
        ];

        $subAttributes["{$i}MaximumManufacturerAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "months",
                            "years",
                        ],
                ],
            "default" => "years"
        ];

        $subAttributes["{$i}MinimumMerchantAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "months",
                            "years",
                        ],
                ],
            "default" => "months"
        ];

        $subAttributes["{$i}MaximumMerchantAgeRecommended_unitOfMeasure_AgeRecommendedUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "months",
                            "years",
                        ],
                ],
            "default" => "years"
        ];

        return $subAttributes;
    }
}
