<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Tools
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/Tools.xsd
 */
class Tools extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Tools';
        $this->data["ProductData_{$this->category}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Tools => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Tools_";
        $common = [
            "{$i}GritRating" => [
                "sequence" => "{$s}10",
                "name" => "GritRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Horsepower" => [
                "sequence" => "{$s}20",
                "name" => "Horsepower",
                "minOccurs" => "0",
                "dataType" => "decimal",
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}30",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}Diameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Length" => [
                "sequence" => "{$s}40",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}Length_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}50",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}Width_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}60",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}Height_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}PowerSource" => [
                "sequence" => "{$s}80",
                "name" => "PowerSource",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "battery-powered",
                                "gas-powered",
                                "hydraulic-powered",
                                "air-powered",
                                "corded-electric",
                            ],
                    ],
            ],
            "{$i}Wattage" => [
                "sequence" => "{$s}90",
                "name" => "Wattage",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}Voltage" => [
                "sequence" => "{$s}100",
                "name" => "PowerSource",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Tools_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributesArr = [
            "{$i}Diameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}Length_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}Width_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}Height_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return array_merge($subAttributes, $subAttributesArr);
    }
}
