<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class TiresAndWheels
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/TiresAndWheels.xsd
 */
class TiresAndWheels extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_TIRES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_WHEELS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TIRES_AND_WHEEL_ASSEMBLIES = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'TiresAndWheels';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Tires":
                $this->attributes = array_merge($this->attributes, $this->getTires());
                break;
            case "Wheels":
                $this->attributes = array_merge($this->attributes, $this->getWheels());
                break;
            case "TireAndWheelAssemblies":
                $this->attributes = array_merge($this->attributes, $this->getTireAndWheelAssemblies());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * TiresAndWheels => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_TiresAndWheels_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getTires()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * TiresAndWheels => 10
         * ProductType => 10
         * Tires => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_TiresAndWheels_ProductType_Tires_";

        $attributes = [
            "ProductData_TiresAndWheels_ProductType_Tires" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Tires",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ConstructionType" => [
                "sequence" => "{$s}20",
                "name" => "ConstructionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "B",
                                "D",
                                "R",
                            ],
                    ],
            ],
            "{$i}SpeedRating" => [
                "sequence" => "{$s}50",
                "name" => "SpeedRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "A1",
                                "A2",
                                "A3",
                                "A4",
                                "A5",
                                "A6",
                                "A7",
                                "A8",
                                "B",
                                "C",
                                "D",
                                "E",
                                "F",
                                "G",
                                "J",
                                "K",
                                "L",
                                "M",
                                "N",
                                "P",
                                "Q",
                                "R",
                                "S",
                                "T",
                                "U",
                                "H",
                                "V",
                                "Z",
                                "W",
                                "Y",
                                "SR",
                                "HR",
                                "VR",
                                "ZR",
                                "Other",
                            ],
                    ],
            ],
            "{$i}ModelName" => [
                "sequence" => "{$s}70",
                "name" => "ModelName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}RimDiameter" => [
                "sequence" => "{$s}80",
                "name" => "RimDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}RimDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}TreadDepth" => [
                "sequence" => "{$s}120",
                "name" => "TreadDepth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}TreadDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $attributes;
    }

    public function getWheels()
    {
        // Overriding the MfrPartNumber
        $this->attributes['DescriptionData_MfrPartNumber'] = [
            'sequence' => '30\160',
            'name' => 'MfrPartNumber',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];

        /**
         * Sequence prefix
         * ProductData => 100
         * TiresAndWheels => 10
         * ProductType => 10
         * Wheels => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_TiresAndWheels_ProductType_Wheels_";

        $attributes = [
            "ProductData_TiresAndWheels_ProductType_Wheels" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Wheels",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}PitchCircleDiameter" => [
                "sequence" => "{$s}10",
                "name" => "PitchCircleDiameter",
                "minOccurs" => "1",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}PitchCircleDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ConstructionType" => [
                "sequence" => "{$s}20",
                "name" => "ConstructionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "1-piece",
                                "2-piece",
                                "3-piece",
                            ],
                    ],
            ],
            "{$i}ModelName" => [
                "sequence" => "{$s}70",
                "name" => "ModelName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfHoles" => [
                "sequence" => "{$s}80",
                "name" => "NumberOfHoles",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}NumberOfSpokes" => [
                "sequence" => "{$s}90",
                "name" => "NumberOfSpokes",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}RimDiameter" => [
                "sequence" => "{$s}110",
                "name" => "RimDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}RimDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}RimWidth" => [
                "sequence" => "{$s}120",
                "name" => "RimWidth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}RimWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BoreDiameter" => [
                "sequence" => "{$s}140",
                "name" => "BoreDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}BoreDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $attributes;
    }

    public function getTireAndWheelAssemblies()
    {
        // Overriding the MfrPartNumber
        $this->attributes['DescriptionData_MfrPartNumber'] = [
            'sequence' => '30\160',
            'name' => 'MfrPartNumber',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];

        /**
         * Sequence prefix
         * ProductData => 100
         * TiresAndWheels => 10
         * ProductType => 10
         * TireAndWheelAssemblies => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_TiresAndWheels_ProductType_TireAndWheelAssemblies_";

        $attributes = [
            "ProductData_TiresAndWheels_ProductType_TireAndWheelAssemblies" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "TireAndWheelAssemblies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BoreDiameter" => [
                "sequence" => "{$s}10",
                "name" => "BoreDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}BoreDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ConstructionType" => [
                "sequence" => "{$s}30",
                "name" => "ConstructionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}70",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfHoles" => [
                "sequence" => "{$s}80",
                "name" => "NumberOfHoles",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}PitchCircleDiameter" => [
                "sequence" => "{$s}100",
                "name" => "PitchCircleDiameter",
                "minOccurs" => "1",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}PitchCircleDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}RimDiameter" => [
                "sequence" => "{$s}110",
                "name" => "RimDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}RimDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}RimWidth" => [
                "sequence" => "{$s}120",
                "name" => "RimWidth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}RimWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ModelName" => [
                "sequence" => "{$s}150",
                "name" => "ModelName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSubTires()
    {
        $i = "ProductData_TiresAndWheels_ProductType_Tires_";
        $subAttributes = [
            "{$i}RimDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}TreadDepth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubWheels()
    {
        $i = "ProductData_TiresAndWheels_ProductType_Wheels_";
        $subAttributes = [
            "{$i}PitchCircleDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}RimDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}RimWidth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}BoreDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubTireAndWheelAssemblies()
    {
        $i = "ProductData_TiresAndWheels_ProductType_TireAndWheelAssemblies_";
        $subAttributes = [
            "{$i}PitchCircleDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}RimDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}RimWidth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}BoreDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_TiresAndWheels_";

        $subAttributes = self::SUB_ATTRIBUTES;
        switch ($this->subCategory) {
            case "Tires":
                $subAttributes = array_merge($subAttributes, $this->getSubTires());
                break;
            case "Wheels":
                $subAttributes = array_merge($subAttributes, $this->getSubWheels());
                break;
            case "TireAndWheelAssemblies":
                $subAttributes = array_merge($subAttributes, $this->getSubTireAndWheelAssemblies());
                break;
        }
        return $subAttributes;
    }
}
