<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class ThreeDPrinting
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/ThreeDPrinting.xsd
 */
class ThreeDPrinting extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_DIGITAL_DESIGNS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_THREE_D_PRINTED_PRODUCTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_THREE_D_PRINTABLE_DESIGNS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'ThreeDPrinting';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "DigitalDesigns":
                $this->attributes = array_merge($this->attributes, $this->getDigitalDesigns());
                break;
            case "ThreeDPrintedProduct":
                $this->attributes = array_merge($this->attributes, $this->getThreeDPrintedProduct());
                break;
            case "ThreeDPrintableDesigns":
                $this->attributes = array_merge($this->attributes, $this->getThreeDPrintableDesigns());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * ThreeDPrinting => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ThreeDPrinting_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ColorName",
                                "Material",
                                "Material-Color",
                                "Material-Size",
                                "SizeName",
                                "SizeName-ColorName",
                            ],
                    ],
            ],
            "{$i}DisplayDiameter" => [
                "sequence" => "{$s}30",
                "name" => "DisplayDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}40",
                "name" => "DisplayLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SupportedDevices" => [
                "sequence" => "{$s}350",
                "name" => "SupportedDevices",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getDigitalDesigns()
    {
        return [];
    }

    public function getThreeDPrintedProduct()
    {
        return [];
    }

    public function getThreeDPrintableDesigns()
    {
        return [];
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_ThreeDPrinting_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributesArr = [
            "{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return array_merge($subAttributes, $subAttributesArr);
    }
}
