<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class SportsMemorabilia
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/SportsMemorabilia.xsd
 */
class SportsMemorabilia extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_SPORTS_MEMORABILIA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRADING_CARDS_CARDS_SETS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRADING_CARDS_GRADED_CARDS_INSERTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRADING_CARDS_UNGRADED_INSERTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRADING_CARDS_FACTORY_SEALED = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRADING_CARDS_MISC_TRADING_CARDS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'SportsMemorabilia';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "SportsMemorabilia":
                $this->attributes = array_merge($this->attributes, $this->getSportsMemorabilia());
                break;
            case "TradingCardsCardsSets":
                $this->attributes = array_merge($this->attributes, $this->getTradingCardsCardsSets());
                break;
            case "TradingCardsGradedCardsInserts":
                $this->attributes = array_merge($this->attributes, $this->getTradingCardsGradedCardsInserts());
                break;
            case "TradingCardsUngradedInserts":
                $this->attributes = array_merge($this->attributes, $this->getTradingCardsUngradedInserts());
                break;
            case "TradingCardsFactorySealed":
                $this->attributes = array_merge($this->attributes, $this->getTradingCardsFactorySealed());
                break;
            case "TradingCardsMiscTradingCards":
                $this->attributes = array_merge($this->attributes, $this->getTradingCardsMiscTradingCards());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * SportsMemorabilia => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SportsMemorabilia_";
        $common = [
            "{$i}AuthenticatedBy" => [
                "sequence" => "{$s}20",
                "name" => "AuthenticatedBy",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConditionProvidedBy" => [
                "sequence" => "{$s}40",
                "name" => "ConditionProvidedBy",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConditionRating" => [
                "sequence" => "{$s}50",
                "name" => "ConditionRating",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}EventName" => [
                "sequence" => "{$s}60",
                "name" => "EventName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GameUsed" => [
                "sequence" => "{$s}70",
                "name" => "GameUsed",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}JerseyType" => [
                "sequence" => "{$s}80",
                "name" => "JerseyType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Sport" => [
                "sequence" => "{$s}200",
                "name" => "Sport",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}TeamName" => [
                "sequence" => "{$s}220",
                "name" => "TeamName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getSportsMemorabilia()
    {
        return [];
    }

    public function getTradingCardsCardsSets()
    {
        return [];
    }

    public function getTradingCardsGradedCardsInserts()
    {
        return [];
    }

    public function getTradingCardsUngradedInserts()
    {
        return [];
    }

    public function getTradingCardsFactorySealed()
    {
        return [];
    }

    public function getTradingCardsMiscTradingCards()
    {
        return [];
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_SportsMemorabilia_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
