<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Shoes
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/Shoes.xsd
 */
class Shoes extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Shoes';
        $this->data["ProductData_{$this->category}"] = '';
        $this->data["ProductData_{$this->category}_ClothingType"] = $subCategory;
        $this->subCategory = $subCategory;
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Shoes => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Shoes_";

        $common = [
            "ProductData_Shoes" => [
                "sequence" => "100\\10",
                "name" => "Shoes",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ClothingType" => [
                "sequence" => "{$s}10",
                "name" => "ClothingType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "visible" => false,
                "restriction" => [
                        "optionValues" => [
                            "Accessory",
                            "Bag",
                            "Shoes",
                            "ShoeAccessory",
                            "Handbag",
                            "Eyewear",
                        ],
                    ],
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}20\\20",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "1 US",
                        "1.5 Child UK",
                        "1.5 Child US",
                        "1.5 UK",
                        "1.5 US",
                        "10 Child UK",
                        "10 Child US",
                        "10 UK",
                        "10 US",
                        "10.5 Child UK",
                        "10.5 Child US",
                        "10.5 UK",
                        "10.5 US",
                        "11 Child UK",
                        "11 Child US",
                        "11 UK",
                        "11 US",
                        "11.5 Child UK",
                        "11.5 Child US",
                        "11.5 UK",
                        "11.5 US",
                        "12 Child UK",
                        "12 Child US",
                        "12 UK",
                        "12 US",
                        "12.5 Child UK",
                        "12.5 Child US",
                        "12.5 UK",
                        "12.5 US",
                        "12-18 Months",
                        "13 Child UK",
                        "13 Child US",
                        "13 UK",
                        "13 US",
                        "13.5 UK",
                        "13.5 US",
                        "14 UK",
                        "14 US",
                        "14.5 UK",
                        "14.5 US",
                        "15 EU",
                        "15 UK",
                        "15 US",
                        "15.5 EU",
                        "15.5 UK",
                        "15.5 US",
                        "16 EU",
                        "16 UK",
                        "16 US",
                        "16.5 EU",
                        "16.5 UK",
                        "16.5 US",
                        "17 EU",
                        "17 UK",
                        "17 US",
                        "17.5 EU",
                        "18 EU",
                        "18.5 EU",
                        "18-24 Months",
                        "19 EU",
                        "19.5 EU",
                        "2 Child UK",
                        "2 Child US",
                        "2 UK",
                        "2 US",
                        "2.5 Child UK",
                        "2.5 Child US",
                        "2.5 UK",
                        "2.5 US",
                        "20 EU",
                        "20.5 EU",
                        "21 EU",
                        "21.5 EU",
                        "22 EU",
                        "22.5 EU",
                        "23 EU",
                        "23.5 EU",
                        "24 EU",
                        "24.5 EU",
                        "25 EU",
                        "25.5 EU",
                        "26 EU",
                        "26.5 EU",
                        "27 EU",
                        "27.5 EU",
                        "28 EU",
                        "28.5 EU",
                        "29 EU",
                        "29.5 EU",
                        "3 Child UK",
                        "3 Child US",
                        "3 UK",
                        "3 US",
                        "3.5 Child UK",
                        "3.5 Child US",
                        "3.5 UK",
                        "3.5 US",
                        "30 EU",
                        "30.5 EU",
                        "31 EU",
                        "31.5 EU",
                        "32 EU",
                        "32.5 EU",
                        "33 EU",
                        "33.5 EU",
                        "34 EU",
                        "34.5 EU",
                        "35 EU",
                        "35.5 EU",
                        "36 EU",
                        "36.5 EU",
                        "37 EU",
                        "37.5 EU",
                        "38 EU",
                        "38.5 EU",
                        "39 EU",
                        "39.5 EU",
                        "4 Child UK",
                        "4 Child US",
                        "4 UK",
                        "4 US",
                        "4.5 Child UK",
                        "4.5 Child US",
                        "4.5 UK",
                        "4.5 US",
                        "40 EU",
                        "40.5 EU",
                        "41 EU",
                        "41.5 EU",
                        "42 EU",
                        "42.5 EU",
                        "43 EU",
                        "43.5 EU",
                        "44 EU",
                        "44.5 EU",
                        "45 EU",
                        "45.5 EU",
                        "46 EU",
                        "46.5 EU",
                        "47 EU",
                        "47.5 EU",
                        "48 EU",
                        "48.5 EU",
                        "49 EU",
                        "49.5 EU",
                        "5 Child UK",
                        "5 Child US",
                        "5 UK",
                        "5 US",
                        "5.5 Child UK",
                        "5.5 Child US",
                        "5.5 UK",
                        "5.5 US",
                        "50 EU",
                        "50.5 EU",
                        "51 EU",
                        "51.5 EU",
                        "52 EU",
                        "52.5 EU",
                        "53 EU",
                        "53.5 EU",
                        "54 EU",
                        "54.5 EU",
                        "55 EU",
                        "55.5 EU",
                        "56 EU",
                        "56.5 EU",
                        "57 EU",
                        "57.5 EU",
                        "58 EU",
                        "58.5 EU",
                        "59 EU",
                        "59.5 EU",
                        "6 Child UK",
                        "6 Child US",
                        "6 UK",
                        "6 US",
                        "6.5 Child UK",
                        "6.5 Child US",
                        "6.5 UK",
                        "6.5 US",
                        "6-12 Months",
                        "7 Child UK",
                        "7 Child US",
                        "7 UK",
                        "7 US",
                        "7.5 Child UK",
                        "7.5 Child US",
                        "7.5 UK",
                        "7.5 US",
                        "8 Child UK",
                        "8 Child US",
                        "8 UK",
                        "8 US",
                        "8.5 Child UK",
                        "8.5 Child US",
                        "8.5 UK",
                        "8.5 US",
                        "9 Child UK",
                        "9 Child US",
                        "9 UK",
                        "9 US",
                        "9.5 Child UK",
                        "9.5 Child US",
                        "9.5 UK",
                        "9.5 US",
                        "L",
                        "M",
                        "S",
                        "XL",
                        "XS",
                        "XXL",
                        "One Size",
                    ],
                ],
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}20\\30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "Size",
                                "Color",
                                "SizeColor",
                                "ColorName-MagnificationStrength",
                                "ColorName-LensColor",
                                "ColorName-LensWidth",
                                "Material",
                                "SizeStyle",
                                "StyleName",
                                "PatternName",
                                "Size-Material",
                                "Size-PatternName",
                                "LensColor",
                                "LensColorShape",
                                "LensColorMaterial",
                                "ColorSize",
                            ],
                    ],
            ],
            "{$i}ClassificationData_BaseLength" => [
                "sequence" => "{$s}30\\10",
                "name" => "BaseLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}BaseLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ClassificationData_ColorMap" => [
                "sequence" => "{$s}30\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Beige",
                        "Black",
                        "Blue",
                        "Brown",
                        "Gold",
                        "Green",
                        "Grey",
                        "Multicolor",
                        "Off White",
                        "Orange",
                        "Pink",
                        "Purple",
                        "Red",
                        "Silver",
                        "Transparent",
                        "Turquoise",
                        "White",
                        "Yellow",
                    ]
                ]
            ],
            "{$i}ClassificationData_SizeMap" => [
                "sequence" => "{$s}30\\30",
                "name" => "SizeMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "1 US",
                        "1.5 Child UK",
                        "1.5 Child US",
                        "1.5 UK",
                        "1.5 US",
                        "10 Child UK",
                        "10 Child US",
                        "10 UK",
                        "10 US",
                        "10.5 Child UK",
                        "10.5 Child US",
                        "10.5 UK",
                        "10.5 US",
                        "11 Child UK",
                        "11 Child US",
                        "11 UK",
                        "11 US",
                        "11.5 Child UK",
                        "11.5 Child US",
                        "11.5 UK",
                        "11.5 US",
                        "12 Child UK",
                        "12 Child US",
                        "12 UK",
                        "12 US",
                        "12.5 Child UK",
                        "12.5 Child US",
                        "12.5 UK",
                        "12.5 US",
                        "12-18 Months",
                        "13 Child UK",
                        "13 Child US",
                        "13 UK",
                        "13 US",
                        "13.5 UK",
                        "13.5 US",
                        "14 UK",
                        "14 US",
                        "14.5 UK",
                        "14.5 US",
                        "15 EU",
                        "15 UK",
                        "15 US",
                        "15.5 EU",
                        "15.5 UK",
                        "15.5 US",
                        "16 EU",
                        "16 UK",
                        "16 US",
                        "16.5 EU",
                        "16.5 UK",
                        "16.5 US",
                        "17 EU",
                        "17 UK",
                        "17 US",
                        "17.5 EU",
                        "18 EU",
                        "18.5 EU",
                        "18-24 Months",
                        "19 EU",
                        "19.5 EU",
                        "2 Child UK",
                        "2 Child US",
                        "2 UK",
                        "2 US",
                        "2.5 Child UK",
                        "2.5 Child US",
                        "2.5 UK",
                        "2.5 US",
                        "20 EU",
                        "20.5 EU",
                        "21 EU",
                        "21.5 EU",
                        "22 EU",
                        "22.5 EU",
                        "23 EU",
                        "23.5 EU",
                        "24 EU",
                        "24.5 EU",
                        "25 EU",
                        "25.5 EU",
                        "26 EU",
                        "26.5 EU",
                        "27 EU",
                        "27.5 EU",
                        "28 EU",
                        "28.5 EU",
                        "29 EU",
                        "29.5 EU",
                        "3 Child UK",
                        "3 Child US",
                        "3 UK",
                        "3 US",
                        "3.5 Child UK",
                        "3.5 Child US",
                        "3.5 UK",
                        "3.5 US",
                        "30 EU",
                        "30.5 EU",
                        "31 EU",
                        "31.5 EU",
                        "32 EU",
                        "32.5 EU",
                        "33 EU",
                        "33.5 EU",
                        "34 EU",
                        "34.5 EU",
                        "35 EU",
                        "35.5 EU",
                        "36 EU",
                        "36.5 EU",
                        "37 EU",
                        "37.5 EU",
                        "38 EU",
                        "38.5 EU",
                        "39 EU",
                        "39.5 EU",
                        "4 Child UK",
                        "4 Child US",
                        "4 UK",
                        "4 US",
                        "4.5 Child UK",
                        "4.5 Child US",
                        "4.5 UK",
                        "4.5 US",
                        "40 EU",
                        "40.5 EU",
                        "41 EU",
                        "41.5 EU",
                        "42 EU",
                        "42.5 EU",
                        "43 EU",
                        "43.5 EU",
                        "44 EU",
                        "44.5 EU",
                        "45 EU",
                        "45.5 EU",
                        "46 EU",
                        "46.5 EU",
                        "47 EU",
                        "47.5 EU",
                        "48 EU",
                        "48.5 EU",
                        "49 EU",
                        "49.5 EU",
                        "5 Child UK",
                        "5 Child US",
                        "5 UK",
                        "5 US",
                        "5.5 Child UK",
                        "5.5 Child US",
                        "5.5 UK",
                        "5.5 US",
                        "50 EU",
                        "50.5 EU",
                        "51 EU",
                        "51.5 EU",
                        "52 EU",
                        "52.5 EU",
                        "53 EU",
                        "53.5 EU",
                        "54 EU",
                        "54.5 EU",
                        "55 EU",
                        "55.5 EU",
                        "56 EU",
                        "56.5 EU",
                        "57 EU",
                        "57.5 EU",
                        "58 EU",
                        "58.5 EU",
                        "59 EU",
                        "59.5 EU",
                        "6 Child UK",
                        "6 Child US",
                        "6 UK",
                        "6 US",
                        "6.5 Child UK",
                        "6.5 Child US",
                        "6.5 UK",
                        "6.5 US",
                        "6-12 Months",
                        "7 Child UK",
                        "7 Child US",
                        "7 UK",
                        "7 US",
                        "7.5 Child UK",
                        "7.5 Child US",
                        "7.5 UK",
                        "7.5 US",
                        "8 Child UK",
                        "8 Child US",
                        "8 UK",
                        "8 US",
                        "8.5 Child UK",
                        "8.5 Child US",
                        "8.5 UK",
                        "8.5 US",
                        "9 Child UK",
                        "9 Child US",
                        "9 UK",
                        "9 US",
                        "9.5 Child UK",
                        "9.5 Child US",
                        "9.5 UK",
                        "9.5 US",
                        "L",
                        "M",
                        "S",
                        "XL",
                        "XS",
                        "XXL",
                        "One Size",
                    ],
                ],
            ],
            "{$i}ClassificationData_ArchType" => [
                "sequence" => "{$s}30\\50",
                "name" => "ArchType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_ShoeClosureType" => [
                "sequence" => "{$s}30\\100",
                "name" => "ShoeClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_Department" => [
                "sequence" => "{$s}30\\120",
                "name" => "Department",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "unisex-adult",
                        "unisex-child",
                        "boys",
                        "womens",
                        "girls",
                        "mens",
                    ],
                ],
            ],
            "{$i}ClassificationData_FabricType" => [
                "sequence" => "{$s}30\\150",
                "name" => "FabricType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_HeelHeight" => [
                "sequence" => "{$s}30\\250",
                "name" => "HeelHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}HeelHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ClassificationData_InnerMaterial" => [
                "sequence" => "{$s}30\\300",
                "name" => "InnerMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Fur",
                        "Leather",
                        "Manmade",
                        "Mesh",
                        "Shearling",
                        "Synthetic Fur",
                        "Textile",
                        "Without Inner Material",
                        "Wool",
                        "Fur",
                        "Leather",
                        "Manmade",
                        "Mesh",
                        "Shearling",
                        "Synthetic Fur",
                        "Textile",
                        "Without Inner Material",
                        "Wool",
                    ]
                ]
            ],
            "{$i}ClassificationData_SportType" => [
                "sequence" => "{$s}30\\600",
                "name" => "SportType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_LeatherType" => [
                "sequence" => "{$s}30\\650",
                "name" => "LeatherType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_MaterialType" => [
                "sequence" => "{$s}30\\660",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "100-percent-cotton",
                        "Rubber",
                        "acetate",
                        "acrylic",
                        "alpaca",
                        "angora",
                        "blend",
                        "buckskin",
                        "calfskin",
                        "canvas",
                        "cashmere",
                        "cashmere-blend",
                        "chamois",
                        "cotton",
                        "cotton-blend",
                        "cotton-rich",
                        "crocodile",
                        "dacron",
                        "down",
                        "egyptian-cotton",
                        "elastic",
                        "exotic",
                        "fabric",
                        "faux-fur",
                        "fleece",
                        "fur",
                        "gore-tex",
                        "haircalf",
                        "hemp",
                        "kevlar",
                        "lace",
                        "leather",
                        "leather-and-fabric",
                        "leather-and-mesh",
                        "leather-and-rubber",
                        "leather-and-synthetic",
                        "linen",
                        "linen-blend",
                        "lizard",
                        "lurex",
                        "lycra",
                        "lycra-blend",
                        "mercerized-cotton",
                        "merino-wool",
                        "mesh",
                        "microfiber",
                        "microsuede",
                        "mohair",
                        "nappa-leather",
                        "neoprene",
                        "nubuck",
                        "nylon",
                        "ostrich",
                        "patent-leather",
                        "pima-cotton",
                        "plastic",
                        "pleather",
                        "polartec-fleece",
                        "poly-cotton",
                        "poly-rayon",
                        "polyester",
                        "polyester-blend",
                        "polypropylene",
                        "pony",
                        "rayon",
                        "rayon-blend",
                        "rubber",
                        "satin",
                        "shearling",
                        "sheepskin",
                        "shetland",
                        "silk",
                        "silk-blend",
                        "snakeskin",
                        "spandex",
                        "straw",
                        "suede",
                        "synthetic",
                        "synthetic-and-fabric",
                        "synthetic-and-leather",
                        "synthetic-and-mesh",
                        "synthetic-and-rubber",
                        "tencel",
                        "thinsulate",
                        "ultrasuede",
                        "urethane",
                        "velcro",
                        "velvet",
                        "vinyl",
                        "viscose",
                        "viscose-rayon",
                        "water-snake",
                        "wood",
                        "wool",
                        "wool-blend",
                        "worsted-wool",
                    ]
                ],
            ],
            "{$i}ClassificationData_OuterMaterialType" => [
                "sequence" => "{$s}30\\700",
                "name" => "OuterMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Beaded",
                        "Canvas",
                        "Felt",
                        "Nubuck Leather",
                        "Other Leather",
                        "Patent Leather",
                        "Rubber",
                        "Satin",
                        "Silk ",
                        "Smooth Leather",
                        "Suede Leather",
                        "Synthetic",
                        "Velvet",
                        "Wool",
                    ],
                ],
            ],
            "{$i}ClassificationData_SoleMaterial" => [
                "sequence" => "{$s}30\\1000",
                "name" => "SoleMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Bast",
                        "EVA",
                        "Gum Rubber",
                        "Leather",
                        "Other materials",
                        "PU",
                        "Resin",
                        "Synthetic",
                    ],
                ],
            ],
            "{$i}ClassificationData_TargetGender" => [
                "sequence" => "{$s}30\\1100",
                "name" => "TargetGender",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "male",
                        "female",
                        "unisex",
                    ]
                ]
            ],
            "{$i}ClassificationData_ShoeWidth" => [
                "sequence" => "{$s}30\\1150",
                "name" => "ShoeWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ShoeSizeComplianceData_AgeRangeDescription" => [
                "sequence" => "{$s}40\\1175",
                "name" => "AgeRangeDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "adult",
                        "big_kid",
                        "little_kid",
                        "toddler",
                        "infant"
                    ]
                ]
            ],
            "{$i}ShoeSizeComplianceData_FootwearSizeSystem" => [
                "sequence" => "{$s}40\\1200",
                "name" => "FootwearSizeSystem",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues"  => [
                        "us_footwear_size_system",
                        "eu_footwear_size_system",
                        "uk_footwear_size_system",
                        "jp_footwear_size_system"
                    ]
                ],
                "dataType" => "StringNotNull",
            ],
            "{$i}ShoeSizeComplianceData_ShoeSizeAgeGroup" => [
                "sequence" => "{$s}40\\1250",
                "name" => "ShoeSizeAgeGroup",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "adult",
                        "big_kid",
                        "little_kid",
                        "toddler",
                        "infant"
                    ]
                ]
            ],
            "{$i}ShoeSizeComplianceData_ShoeSizeGender" => [
                "sequence" => "{$s}40\\1275",
                "name" => "ShoeSizeGender",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "men",
                        "women",
                    ]
                ]
            ],

            "{$i}ShoeSizeComplianceData_ShoeSizeClass" => [
                "sequence" => "{$s}40\\1400",
                "name" => "ShoeSizeClass",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "numeric",
                        "numeric_range",
                        "alpha",
                        "alpha_range",
                        "age",
                        "age_range",
                        "measurement",
                        "measurement_range"
                    ],
                ]
            ],
            "{$i}ShoeSizeComplianceData_ShoeSizeWidth" => [
                "sequence" => "{$s}40\\1550",
                "name" => "ShoeSizeWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "medium",
                        "narrow",
                        "wide",
                        "x_narrow",
                        "x_wide",
                        "xx_narrow",
                        "xx_wide",
                        "xxx_narrow",
                        "xxx_wide",
                    ],
                ],
            ],
            "{$i}ShoeSizeComplianceData_ShoeSize" => [
                "sequence" => "{$s}40\\1600",
                "name" => "ShoeSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "0_months",
                        "3_months",
                        "6_months",
                        "9_months",
                        "12_months",
                        "15_months",
                        "18_months",
                        "21_months",
                        "24_months",
                        "2_years",
                        "2_point_5_years",
                        "3_years",
                        "3_point_5_years",
                        "4_years",
                        "4_point_5_years",
                        "5_years",
                        "numeric_0",
                        "numeric_0_point_5",
                        "numeric_1",
                        "numeric_1_point_5",
                        "numeric_2",
                        "numeric_2_point_5",
                        "numeric_3",
                        "numeric_3_point_5",
                        "numeric_4",
                        "numeric_4_point_5",
                        "numeric_5",
                        "numeric_5_point_5",
                        "numeric_6",
                        "numeric_6_point_5",
                        "numeric_7",
                        "numeric_7_point_5",
                        "numeric_8",
                        "numeric_8_point_5",
                        "numeric_9",
                        "numeric_9_point_5",
                        "numeric_10",
                        "numeric_10_point_5",
                        "numeric_11",
                        "numeric_11_point_5",
                        "numeric_12",
                        "numeric_12_point_5",
                        "numeric_13",
                        "numeric_13_point_5",
                        "numeric_14",
                        "numeric_14_point_5",
                        "numeric_15",
                        "numeric_15_point_5",
                        "numeric_16",
                        "numeric_16_point_5",
                        "numeric_17",
                        "numeric_17_point_5",
                        "numeric_18",
                        "numeric_18_point_5",
                        "numeric_19",
                        "numeric_19_point_5",
                        "numeric_20",
                        "one_size",
                        "xxx_s",
                        "xx_s",
                        "x_s",
                        // Enumerations 'ss' , 'll' are applicable for JP only
                        "ss",
                        "small",
                        "medium",
                        "large",
                        "ll",
                        "x_l",
                        "xx_l",
                        "xxx_l",
                        // Below enumerations are applicable for ES,FR,IT& DE only
                        "fraction_14_and_1_ninth",
                        "fraction_14_and_1_third",
                        "fraction_14_and_2_thirds",
                        "fraction_15_and_1_ninth",
                        "fraction_15_and_1_third",
                        "fraction_15_and_2_thirds",
                        "fraction_16_and_1_ninth",
                        "fraction_16_and_1_third",
                        "fraction_16_and_2_thirds",
                        "fraction_17_and_1_ninth",
                        "fraction_17_and_1_third",
                        "fraction_17_and_2_thirds",
                        "fraction_18_and_1_ninth",
                        "fraction_18_and_1_third",
                        "fraction_18_and_2_thirds",
                        "fraction_19_and_1_ninth",
                        "fraction_19_and_1_third",
                        "fraction_19_and_2_thirds",
                        "fraction_20_and_1_ninth",
                        "fraction_20_and_1_third",
                        "numeric_20_point_5",
                        "fraction_20_and_2_thirds",
                        "numeric_21",
                        "fraction_21_and_1_ninth",
                        "fraction_21_and_1_third",
                        "numeric_21_point_5",
                        "fraction_21_and_2_thirds",
                        "numeric_22",
                        "fraction_22_and_1_ninth",
                        "fraction_22_and_1_third",
                        "numeric_22_point_5",
                        "fraction_22_and_2_thirds",
                        "numeric_23",
                        "fraction_23_and_1_ninth",
                        "fraction_23_and_1_third",
                        "numeric_23_point_5",
                        "fraction_23_and_2_thirds",
                        "numeric_24",
                        "fraction_24_and_1_ninth",
                        "fraction_24_and_1_third",
                        "numeric_24_point_5",
                        "fraction_24_and_2_thirds",
                        "numeric_25",
                        "fraction_25_and_1_ninth",
                        "fraction_25_and_1_third",
                        "numeric_25_point_5",
                        "fraction_25_and_2_thirds",
                        "numeric_26",
                        "fraction_26_and_1_ninth",
                        "fraction_26_and_1_third",
                        "numeric_26_point_5",
                        "fraction_26_and_2_thirds",
                        "numeric_27",
                        "fraction_27_and_1_ninth",
                        "fraction_27_and_1_third",
                        "numeric_27_point_5",
                        "fraction_27_and_2_thirds",
                        "numeric_28",
                        "fraction_28_and_1_ninth",
                        "fraction_28_and_1_third",
                        "numeric_28_point_5",
                        "fraction_28_and_2_thirds",
                        "numeric_29",
                        "fraction_29_and_1_ninth",
                        "fraction_29_and_1_third",
                        "numeric_29_point_5",
                        "fraction_29_and_2_thirds",
                        "numeric_30",
                        "fraction_30_and_1_ninth",
                        "fraction_30_and_1_third",
                        "numeric_30_point_5",
                        "fraction_30_and_2_thirds",
                        "numeric_31",
                        "fraction_31_and_1_ninth",
                        "fraction_31_and_1_third",
                        "numeric_31_point_5",
                        "fraction_31_and_2_thirds",
                        "numeric_32",
                        "fraction_32_and_1_ninth",
                        "fraction_32_and_1_third",
                        "numeric_32_point_5",
                        "fraction_32_and_2_thirds",
                        "numeric_33",
                        "fraction_33_and_1_ninth",
                        "fraction_33_and_1_third",
                        "numeric_33_point_5",
                        "fraction_33_and_2_thirds",
                        "numeric_34",
                        "fraction_34_and_1_ninth",
                        "fraction_34_and_1_third",
                        "numeric_34_point_5",
                        "fraction_34_and_2_thirds",
                        "numeric_35",
                        "fraction_35_and_1_ninth",
                        "fraction_35_and_1_third",
                        "numeric_35_point_5",
                        "fraction_35_and_2_thirds",
                        "numeric_36",
                        "fraction_36_and_1_ninth",
                        "fraction_36_and_1_third",
                        "numeric_36_point_5",
                        "fraction_36_and_2_thirds",
                        "numeric_37",
                        "fraction_37_and_1_ninth",
                        "fraction_37_and_1_third",
                        "numeric_37_point_5",
                        "fraction_37_and_2_thirds",
                        "numeric_38",
                        "fraction_38_and_1_ninth",
                        "fraction_38_and_1_third",
                        "numeric_38_point_5",
                        "fraction_38_and_2_thirds",
                        "numeric_39",
                        "fraction_39_and_1_ninth",
                        "fraction_39_and_1_third",
                        "numeric_39_point_5",
                        "fraction_39_and_2_thirds",
                        "numeric_40",
                        "fraction_40_and_1_ninth",
                        "fraction_40_and_1_third",
                        "numeric_40_point_5",
                        "fraction_40_and_2_thirds",
                        "numeric_41",
                        "fraction_41_and_1_ninth",
                        "fraction_41_and_1_third",
                        "numeric_41_point_5",
                        "fraction_41_and_2_thirds",
                        "numeric_42",
                        "fraction_42_and_1_ninth",
                        "fraction_42_and_1_third",
                        "numeric_42_point_5",
                        "fraction_42_and_2_thirds",
                        "numeric_43",
                        "fraction_43_and_1_ninth",
                        "fraction_43_and_1_third",
                        "numeric_43_point_5",
                        "fraction_43_and_2_thirds",
                        "numeric_44",
                        "fraction_44_and_1_ninth",
                        "fraction_44_and_1_third",
                        "numeric_44_point_5",
                        "fraction_44_and_2_thirds",
                        "numeric_45",
                        "fraction_45_and_1_ninth",
                        "fraction_45_and_1_third",
                        "numeric_45_point_5",
                        "fraction_45_and_2_thirds",
                        "numeric_46",
                        "fraction_46_and_1_ninth",
                        "fraction_46_and_1_third",
                        "numeric_46_point_5",
                        "fraction_46_and_2_thirds",
                        "numeric_47",
                        "fraction_47_and_1_ninth",
                        "fraction_47_and_1_third",
                        "numeric_47_point_5",
                        "fraction_47_and_2_thirds",
                        "numeric_48",
                        "fraction_48_and_1_ninth",
                        "fraction_48_and_1_third",
                        "numeric_48_point_5",
                        "fraction_48_and_2_thirds",
                        "numeric_49",
                        "fraction_49_and_1_ninth",
                        "fraction_49_and_1_third",
                        "numeric_49_point_5",
                        "fraction_49_and_2_thirds",
                        "numeric_50",
                        "fraction_50_and_1_ninth",
                        "fraction_50_and_1_third",
                        "numeric_50_point_5",
                        "fraction_50_and_2_thirds",
                        "numeric_51",
                        "fraction_51_and_1_ninth",
                        "fraction_51_and_1_third",
                        "numeric_51_point_5",
                        "fraction_51_and_2_thirds",
                        "numeric_52",
                        "fraction_52_and_1_ninth",
                        "fraction_52_and_1_third",
                        "numeric_52_point_5",
                        "fraction_52_and_2_thirds",
                        "numeric_53",
                        "fraction_53_and_1_ninth",
                        "fraction_53_and_1_third",
                        "numeric_53_point_5",
                        "fraction_53_and_2_thirds",
                        "numeric_54",
                        "fraction_54_and_1_ninth",
                        "fraction_54_and_1_third",
                        "numeric_54_point_5",
                        "fraction_54_and_2_thirds",
                        "numeric_55",
                        "fraction_55_and_1_ninth",
                        "fraction_55_and_1_third",
                        "numeric_55_point_5",
                        "fraction_55_and_2_thirds",
                        "numeric_56",
                        "fraction_56_and_1_ninth",
                        "fraction_56_and_1_third",
                        "numeric_56_point_5",
                        "fraction_56_and_2_thirds",
                        "numeric_57",
                        "fraction_57_and_1_ninth",
                        "fraction_57_and_1_third",
                        "numeric_57_point_5",
                        "fraction_57_and_2_thirds",
                        "numeric_58",
                        "fraction_58_and_1_ninth",
                        "fraction_58_and_1_third",
                        "numeric_58_point_5",
                        "fraction_58_and_2_thirds",
                        "numeric_59",
                        "fraction_59_and_1_ninth",
                        "fraction_59_and_1_third",
                        "fraction_59_and_2_thirds",
                        "numeric_59_point_5",
                        "numeric_60",
                        // Below enumerations are applicable for JP measurement/ measurement_range class only
                        "measurement_10_point_0_centimeters",
                        "measurement_10_point_5_centimeters",
                        "measurement_11_point_0_centimeters",
                        "measurement_11_point_5_centimeters",
                        "measurement_12_point_0_centimeters",
                        "measurement_12_point_5_centimeters",
                        "measurement_13_point_0_centimeters",
                        "measurement_13_point_5_centimeters",
                        "measurement_14_point_0_centimeters",
                        "measurement_14_point_5_centimeters",
                        "measurement_15_point_0_centimeters",
                        "measurement_15_point_5_centimeters",
                        "measurement_16_point_0_centimeters",
                        "measurement_16_point_5_centimeters",
                        "measurement_17_point_0_centimeters",
                        "measurement_17_point_5_centimeters",
                        "measurement_18_point_0_centimeters",
                        "measurement_18_point_5_centimeters",
                        "measurement_19_point_0_centimeters",
                        "measurement_19_point_5_centimeters",
                        "measurement_20_point_0_centimeters",
                        "measurement_20_point_5_centimeters",
                        "measurement_21_point_0_centimeters",
                        "measurement_21_point_5_centimeters",
                        "measurement_22_point_0_centimeters",
                        "measurement_22_point_5_centimeters",
                        "measurement_23_point_0_centimeters",
                        "measurement_23_point_5_centimeters",
                        "measurement_24_point_0_centimeters",
                        "measurement_24_point_5_centimeters",
                        "measurement_25_point_0_centimeters",
                        "measurement_25_point_5_centimeters",
                        "measurement_26_point_0_centimeters",
                        "measurement_26_point_5_centimeters",
                        "measurement_27_point_0_centimeters",
                        "measurement_27_point_5_centimeters",
                        "measurement_28_point_0_centimeters",
                        "measurement_28_point_5_centimeters",
                        "measurement_29_point_0_centimeters",
                        "measurement_29_point_5_centimeters",
                        "measurement_30_point_0_centimeters",
                        "measurement_30_point_5_centimeters",
                        "measurement_31_point_0_centimeters",
                        "measurement_31_point_5_centimeters",
                        "measurement_32_point_0_centimeters",
                        "measurement_32_point_5_centimeters",
                        "measurement_33_point_0_centimeters",
                        "measurement_33_point_5_centimeters",
                        "measurement_34_point_0_centimeters",
                        "measurement_34_point_5_centimeters",
                        "measurement_35_point_0_centimeters",
                        "measurement_35_point_5_centimeters",
                        "measurement_36_point_0_centimeters",
                        "measurement_36_point_5_centimeters",
                        "measurement_37_point_0_centimeters",
                        "measurement_37_point_5_centimeters",
                        "measurement_38_point_0_centimeters",
                        "measurement_38_point_5_centimeters",
                        "measurement_39_point_0_centimeters",
                        "measurement_39_point_5_centimeters",
                        "measurement_40_point_0_centimeters",
                    ],
                ],
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        switch ($this->subCategory) {
            case "Shoes":
                $this->attributes = array_merge($this->attributes, $this->getShoes());
                break;
        }

        if (isset($params) && !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    public function getShoes()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Shoes => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Shoes_";
        $this->attributes["{$i}VariationData_Size"]["minOccurs"] = "1";
        $this->attributes["{$i}VariationData_Color"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ClassificationData_TargetGender"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ClassificationData_ShoeWidth"]["minOccurs"] = "1";

        $this->attributes["ProductData_Shoes_ShoeSizeComplianceData_AgeRangeDescription"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ShoeSizeComplianceData_FootwearSizeSystem"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ShoeSizeComplianceData_ShoeSizeAgeGroup"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ShoeSizeComplianceData_ShoeSizeClass"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ShoeSizeComplianceData_ShoeSizeWidth"]["minOccurs"] = "1";
        $this->attributes["ProductData_Shoes_ShoeSizeComplianceData_ShoeSizeGender"]["minOccurs"] = "1";
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Shoes_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributesArr = [
            "{$i}BaseLength_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HeelHeight_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return array_merge($subAttributes, $subAttributesArr);
    }
}
