<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class PowerTransmission extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_BEARINGS_AND_BUSHINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BELTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPRESSION_SPRINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_EXTENSION_SPRINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FLEXIBLE_COUPLINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GEARS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RIGID_COUPLINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SHAFTCOLLAR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TORSION_SPRINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LINEAR_GUIDES_AND_RAILS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PULLEYS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ROLLER_CHAIN = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COUPLINGS_COLLARS_AND_UNIVERSAL_JOINTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SPRINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SPROCKETS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_UNIVERSAL_JOINTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'PowerTransmission';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "BearingsAndBushings":
                $this->attributes = array_merge($this->attributes, $this->getBearingsAndBushings());
                break;
            case "Belts":
                $this->attributes = array_merge($this->attributes, $this->getBelts());
                break;
            case "CompressionSprings":
                $this->attributes = array_merge($this->attributes, $this->getCompressionSprings());
                break;
            case "ExtensionSprings":
                $this->attributes = array_merge($this->attributes, $this->getExtensionSprings());
                break;
            case "FlexibleCouplings":
                $this->attributes = array_merge($this->attributes, $this->getFlexibleCouplings());
                break;
            case "Gears":
                $this->attributes = array_merge($this->attributes, $this->getGears());
                break;
            case "RigidCouplings":
                $this->attributes = array_merge($this->attributes, $this->getRigidCouplings());
                break;
            case "ShaftCollar":
                $this->attributes = array_merge($this->attributes, $this->getShaftCollar());
                break;
            case "TorsionSprings":
                $this->attributes = array_merge($this->attributes, $this->getTorsionSprings());
                break;
            case "LinearGuidesAndRails":
                $this->attributes = array_merge($this->attributes, $this->getLinearGuidesAndRails());
                break;
            case "Pulleys":
                $this->attributes = array_merge($this->attributes, $this->getPulleys());
                break;
            case "RollerChain":
                $this->attributes = array_merge($this->attributes, $this->getRollerChain());
                break;
            case "CouplingsCollarsAndUniversalJoints":
                $this->attributes = array_merge($this->attributes, $this->getCouplingsCollarsAndUniversalJoints());
                break;
            case "Springs":
                $this->attributes = array_merge($this->attributes, $this->getSprings());
                break;
            case "Sprockets":
                $this->attributes = array_merge($this->attributes, $this->getSprockets());
                break;
            case "UniversalJoints":
                $this->attributes = array_merge($this->attributes, $this->getUniversalJoints());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_";
        $common = [
            "{$i}ActiveCoils" => [
                "sequence" => "{$s}20",
                "name" => "ActiveCoils",
                "dataType" => "integer",
                "minOccurs" => "0",
            ],
            "{$i}BeltCrossSection" => [
                "sequence" => "{$s}40",
                "name" => "BeltCrossSection",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}BeltCrossSection_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BeltWidth" => [
                "sequence" => "{$s}50",
                "name" => "BeltWidth",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}BeltWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BodyOutsideDiameter" => [
                "sequence" => "{$s}60",
                "name" => "BodyOutsideDiameter",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}BodyOutsideDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BoreDiameter" => [
                "sequence" => "{$s}70",
                "name" => "BoreDiameter",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}BoreDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}FaceWidth" => [
                "sequence" => "{$s}100",
                "name" => "FaceWidth",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}FaceWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}FlangeOutsideDiameter" => [
                "sequence" => "{$s}120",
                "name" => "FlangeOutsideDiameter",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}FlangeOutsideDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getBearingsAndBushings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * BearingsAndBushings => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_BearingsAndBushings_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_BearingsAndBushings" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "BearingsAndBushings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getBelts()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * Belts => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_Belts_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_Belts" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Belts",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getCompressionSprings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * CompressionSprings => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_CompressionSprings_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_CompressionSprings" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CompressionSprings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getExtensionSprings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * ExtensionSprings => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_ExtensionSprings_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_ExtensionSprings" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "ExtensionSprings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getFlexibleCouplings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * FlexibleCouplings => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_FlexibleCouplings_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_FlexibleCouplings" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "FlexibleCouplings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getGears()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * Gears => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_Gears_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_Gears" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Gears",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getRigidCouplings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * RigidCouplings => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_RigidCouplings_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_RigidCouplings" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "RigidCouplings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getShaftCollar()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * ShaftCollar => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_ShaftCollar_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_ShaftCollar" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "ShaftCollar",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getTorsionSprings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * TorsionSprings => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_TorsionSprings_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_TorsionSprings" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "TorsionSprings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getLinearGuidesAndRails()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * LinearGuidesAndRails => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_LinearGuidesAndRails_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_LinearGuidesAndRails" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "LinearGuidesAndRails",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getPulleys()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * Pulleys => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_Pulleys_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_Pulleys" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Pulleys",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getRollerChain()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * RollerChain => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_RollerChain_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_RollerChain" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "RollerChain",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getCouplingsCollarsAndUniversalJoints()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * CouplingsCollarsAndUniversalJoints => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_CouplingsCollarsAndUniversalJoints_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_CouplingsCollarsAndUniversalJoints" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CouplingsCollarsAndUniversalJoints",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSprings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * Springs => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_Springs_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_Springs" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Springs",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSprockets()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * Sprockets => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_Sprockets_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_Sprockets" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Sprockets",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getUniversalJoints()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PowerTransmission => 10
         * ProductType => 10
         * UniversalJoints => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_ProductType_UniversalJoints_";

        $attributes = [
            "ProductData_PowerTransmission_ProductType_UniversalJoints" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "UniversalJoints",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_PowerTransmission_";

        $subAttributes = self::SUB_ATTRIBUTES;

        $subAttributesArr = [
            "{$i}BeltCrossSection_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                " MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}BeltWidth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                " MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}BodyOutsideDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                " MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}BoreDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                " MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}FaceWidth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                " MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}FlangeOutsideDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                " MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return array_merge($subAttributes, $subAttributesArr);
    }
}
