<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class PetSupplies
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/PetSupplies.xsd
 */
class PetSupplies extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_PET_SUPPLIES_MISC = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'PetSupplies';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "PetSuppliesMisc":
                $this->attributes = array_merge($this->attributes, $this->getPetSuppliesMisc());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * PetSupplies => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PetSupplies_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getPetSuppliesMisc()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * PetSupplies => 10
         * ProductType => 10
         * PetSuppliesMisc => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_PetSupplies_ProductType_PetSuppliesMisc_";

        $this->attributes = [
            "ProductData_Computers_ProductType_PetSuppliesMisc" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PetSuppliesMisc",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Size",
                                "SizeColor",
                                "Flavor",
                                "FlavorSize",
                                "PatternName",
                                "Color-PatternName",
                                "PatternName-Size",
                                "PatternName-Flavor",
                                "Scent",
                            ],
                    ],
            ],
            "{$i}DogSize" => [
                "sequence" => "{$s}200",
                "name" => "DogSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}300",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}500",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PetLifeStage" => [
                "sequence" => "{$s}600",
                "name" => "PetLifeStage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PetType" => [
                "sequence" => "{$s}620",
                "name" => "PetType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_PetSupplies_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
