<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Outdoors extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_OUTDOOR_RECREATION_PRODUCT = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Outdoors';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "OutdoorRecreationProduct":
                $this->attributes = array_merge($this->attributes, $this->getOutdoorRecreationProduct());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Outdoors => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Outdoors_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "ColorLength",
                        "ColorLensColor",
                        "ColorName",
                        "ColorSize",
                        "Length",
                        "LengthSize",
                        "LengthWidth",
                        "LensColor",
                        "ShapeSize",
                        "SizeName",
                        "SizeTensionLevel",
                        "SizeWeight",
                        "SizeWeightSupported",
                        "TensionLevel",
                        "Weight",
                        "Width",
                    ],
                ],
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getOutdoorRecreationProduct()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Outdoors => 10
         * ProductType => 10
         * OutdoorRecreationProduct => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Outdoors_ProductType_OutdoorRecreationProduct_";

        $this->attributes = [
            "ProductData_Outdoors_ProductType_OutdoorRecreationProduct" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "OutdoorRecreationProduct",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Color" => [
                "sequence" => "{$s}10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}200",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}350",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Outdoors_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
