<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Office extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_ART_SUPPLIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_EDUCATIONAL_SUPPLIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_OFFICE_PRODUCTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PAPER_PRODUCTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_WRITING_INSTRUMENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BARCODE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CALCULATOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_INK_TONER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MULTIFUNCTION_DEVICE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_OFFICE_ELECTRONICS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_OFFICE_PHONE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_OFFICE_PRINTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_OFFICE_SCANNER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VOICE_RECORDER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Office';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "ArtSupplies":
                $this->attributes = array_merge($this->attributes, $this->getArtSupplies());
                break;
            case "EducationalSupplies":
                $this->attributes = array_merge($this->attributes, $this->getEducationalSupplies());
                break;
            case "OfficeProducts":
                $this->attributes = array_merge($this->attributes, $this->getOfficeProducts());
                break;
            case "PaperProducts":
                $this->attributes = array_merge($this->attributes, $this->getPaperProducts());
                break;
            case "WritingInstruments":
                $this->attributes = array_merge($this->attributes, $this->getWritingInstruments());
                break;
            case "BarCode":
                $this->attributes = array_merge($this->attributes, $this->getBarCode());
                break;
            case "Calculator":
                $this->attributes = array_merge($this->attributes, $this->getCalculator());
                break;
            case "InkToner":
                $this->attributes = array_merge($this->attributes, $this->getInkToner());
                break;
            case "MultifunctionDevice":
                $this->attributes = array_merge($this->attributes, $this->getMultifunctionDevice());
                break;
            case "OfficeElectronics":
                $this->attributes = array_merge($this->attributes, $this->getOfficeElectronics());
                break;
            case "OfficePhone":
                $this->attributes = array_merge($this->attributes, $this->getOfficePhone());
                break;
            case "OfficePrinter":
                $this->attributes = array_merge($this->attributes, $this->getOfficePrinter());
                break;
            case "OfficeScanner":
                $this->attributes = array_merge($this->attributes, $this->getOfficeScanner());
                break;
            case "VoiceRecorder":
                $this->attributes = array_merge($this->attributes, $this->getVoiceRecorder());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getArtSupplies()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * ArtSupplies => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_ArtSupplies_";

        $this->attributes = [
            "ProductData_Office_ProductType_ArtSupplies" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "ArtSupplies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}20\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorSpecification_ColorMap" => [
                "sequence" => "{$s}20\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PaintType" => [
                "sequence" => "{$s}110",
                "name" => "PaintType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getEducationalSupplies()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * EducationalSupplies => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_EducationalSupplies_";

        $this->attributes = [
            "ProductData_Office_ProductType_EducationalSupplies" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "EducationalSupplies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}20\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorSpecification_ColorMap" => [
                "sequence" => "{$s}20\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PaintType" => [
                "sequence" => "{$s}110",
                "name" => "PaintType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getOfficeProducts()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * OfficeProducts => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_OfficeProducts_";

        $this->attributes = [
            "ProductData_Office_ProductType_OfficeProducts" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "OfficeProducts",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}20\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorSpecification_ColorMap" => [
                "sequence" => "{$s}20\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PaintType" => [
                "sequence" => "{$s}110",
                "name" => "PaintType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getPaperProducts()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * PaperProducts => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_PaperProducts_";

        $this->attributes = [
            "ProductData_Office_ProductType_PaperProducts" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "PaperProducts",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}20\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorSpecification_ColorMap" => [
                "sequence" => "{$s}20\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PaperCornerType" => [
                "sequence" => "{$s}210",
                "name" => "PaperCornerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PaperFinish" => [
                "sequence" => "{$s}220",
                "name" => "PaperFinish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getWritingInstruments()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * WritingInstruments => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_WritingInstruments_";

        $this->attributes = [
            "ProductData_Office_ProductType_WritingInstruments" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "WritingInstruments",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}20\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorSpecification_ColorMap" => [
                "sequence" => "{$s}20\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PaintType" => [
                "sequence" => "{$s}110",
                "name" => "PaintType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getBarCode()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * BarCode => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_BarCode_";

        $this->attributes = [
            "ProductData_Office_ProductType_BarCode" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "BarCode",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Size",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}20",
                "name" => "HardwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InputDeviceInterface" => [
                "sequence" => "{$s}40",
                "name" => "InputDeviceInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConnectivityTechnology" => [
                "sequence" => "{$s}50",
                "name" => "ConnectivityTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}60",
                "name" => "SpecialFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PowerDevice" => [
                "sequence" => "{$s}70",
                "name" => "PowerDevice",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScanElementType" => [
                "sequence" => "{$s}80",
                "name" => "ScanElementType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScanRate" => [
                "sequence" => "{$s}90",
                "name" => "ScanRate",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}100",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getCalculator()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * ArtSupplies => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_ArtSupplies_";

        $this->attributes = [
            "ProductData_Office_ProductType_ArtSupplies" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "ArtSupplies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getInkToner()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * InkToner => 80
         */
        $s = "100\\10\\10\\80\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_InkToner_";

        $this->attributes = [
            "ProductData_Office_ProductType_InkToner" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "InkToner",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "PaperSize",
                                "MaximumExpandableSize",
                                "LineSize",
                                "Size",
                                "NumberOfItems",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}InkColor" => [
                "sequence" => "{$s}20",
                "name" => "InkColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}80",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getMultifunctionDevice()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * MultifunctionDevice => 90
         */
        $s = "100\\10\\10\\90\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_MultifunctionDevice_";

        $this->attributes = [
            "ProductData_Office_ProductType_MultifunctionDevice" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "MultifunctionDevice",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Size",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getOfficeElectronics()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * OfficeElectronics => 100
         */
        $s = "100\\10\\10\\100\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_OfficeElectronics_";

        $this->attributes = [
            "ProductData_Office_ProductType_OfficeElectronics" => [
                "sequence" => "100\\10\\10\\100",
                "name" => "OfficeElectronics",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Size",
                                "SizeColor",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getOfficePhone()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * OfficePhone => 110
         */
        $s = "100\\10\\10\\110\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_OfficePhone_";

        $this->attributes = [
            "ProductData_Office_ProductType_OfficePhone" => [
                "sequence" => "100\\10\\10\\110",
                "name" => "OfficePhone",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}30",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getOfficePrinter()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * OfficePrinter => 120
         */
        $s = "100\\10\\10\\120\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_OfficePrinter_";

        $this->attributes = [
            "ProductData_Office_ProductType_OfficePrinter" => [
                "sequence" => "100\\10\\10\\120",
                "name" => "ArtSupplies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ConnectivityTechnology" => [
                "sequence" => "{$s}20",
                "name" => "ConnectivityTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaxPrintspeedBlackWhite" => [
                "sequence" => "{$s}30",
                "name" => "MaxPrintspeedBlackWhite",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}MaxPrintspeedColor" => [
                "sequence" => "{$s}40",
                "name" => "MaxPrintspeedColor",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}PrinterOutput" => [
                "sequence" => "{$s}50",
                "name" => "PrinterOutput",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PrinterTechnology" => [
                "sequence" => "{$s}60",
                "name" => "PrinterTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}70",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getOfficeScanner()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * OfficeScanner => 130
         */
        $s = "100\\10\\10\\130\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_OfficeScanner_";

        $this->attributes = [
            "ProductData_Office_ProductType_OfficeScanner" => [
                "sequence" => "100\\10\\10\\130",
                "name" => "OfficeScanner",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ConnectivityTechnology" => [
                "sequence" => "{$s}20",
                "name" => "ConnectivityTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getVoiceRecorder()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Office => 10
         * ProductType => 10
         * VoiceRecorder => 140
         */
        $s = "100\\10\\10\\140\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Office_ProductType_VoiceRecorder_";

        $this->attributes = [
            "ProductData_Office_ProductType_VoiceRecorder" => [
                "sequence" => "100\\10\\10\\140",
                "name" => "VoiceRecorder",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Office_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
