<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class MusicalInstruments extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_BRASS_AND_WOODWIND_INSTRUMENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GUITARS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_INSTRUMENT_PARTS_AND_ACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_KEYBOARD_INSTRUMENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MISC_WORLD_INSTRUMENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PERCUSSION_INSTRUMENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SOUND_AND_RECORDING_EQUIPMENT = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_STRINGED_INSTRUMENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        // setting category
        $this->category = 'MusicalInstruments';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "BrassAndWoodwindInstruments":
                $this->attributes = array_merge($this->attributes, $this->getBrassAndWoodwindInstruments());
                break;
            case "Guitars":
                $this->attributes = array_merge($this->attributes, $this->getGuitars());
                break;
            case "InstrumentPartsAndAccessories":
                $this->attributes = array_merge($this->attributes, $this->getInstrumentPartsAndAccessories());
                break;
            case "KeyboardInstruments":
                $this->attributes = array_merge($this->attributes, $this->getKeyboardInstruments());
                break;
            case "MiscWorldInstruments":
                $this->attributes = array_merge($this->attributes, $this->getMiscWorldInstruments());
                break;
            case "PercussionInstruments":
                $this->attributes = array_merge($this->attributes, $this->getPercussionInstruments());
                break;
            case "SoundAndRecordingEquipment":
                $this->attributes = array_merge($this->attributes, $this->getSoundAndRecordingEquipment());
                break;
            case "StringedInstruments":
                $this->attributes = array_merge($this->attributes, $this->getStringedInstruments());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getBrassAndWoodwindInstruments()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * BrassAndWoodwindInstruments => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_BrassAndWoodwindInstruments_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_BrassAndWoodwindInstruments" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "BrassAndWoodwindInstruments",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Size" => [
                "sequence" => "{$s}40",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}60",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MusicalStyle" => [
                "sequence" => "{$s}130",
                "name" => "MusicalStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProficiencyLevel" => [
                "sequence" => "{$s}140",
                "name" => "ProficiencyLevel",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Intermediate",
                                "Professional",
                                "Student",
                            ],
                    ],
            ],
        ];
        return $this->attributes;
    }

    public function getGuitars()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * Guitars => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_Guitars_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_Guitars" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Guitars",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Size" => [
                "sequence" => "{$s}40",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GuitarAttribute" => [
                "sequence" => "{$s}50",
                "name" => "GuitarAttribute",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "dreadnought",
                                "fretless",
                                "grand-auditorium",
                                "grand-concert",
                                "jumbo",
                                "mini",
                                "nex",
                                "shallow-body",
                                "short-scale",
                                "travel",
                            ],
                    ],
            ],
            "{$i}GuitarBridgeSystem" => [
                "sequence" => "{$s}60",
                "name" => "GuitarBridgeSystem",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "adjustable",
                                "double",
                                "edge-pro",
                                "fixed",
                                "floyd-rose",
                                "fulcrum",
                                "hardtail-bridge",
                                "individual-adjustable-bridge-system",
                                "jackson-locking-tremolo",
                                "locking-tremolo",
                                "stop-tail",
                                "tremolo",
                                "tune-o-matic",
                                "vintage-fulcrum-bridge",
                            ],
                    ],
            ],
            "{$i}GuitarPickupConfiguration" => [
                "sequence" => "{$s}70",
                "name" => "GuitarPickupConfiguration",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "combination",
                                "custom-removable-pickups",
                                "humbucker",
                                "magnetic-combination",
                                "magnetic-double-coil",
                                "magnetic-single-coil",
                                "piezoelectric",
                                "single-coil",
                            ],
                    ],
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}80",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}90",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}ScaleLength" => [
                "sequence" => "{$s}110",
                "name" => "ScaleLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}120",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BackMaterial" => [
                "sequence" => "{$s}130",
                "name" => "BackMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BodyMaterial" => [
                "sequence" => "{$s}140",
                "name" => "BodyMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NeckMaterial" => [
                "sequence" => "{$s}150",
                "name" => "NeckMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}StringMaterial" => [
                "sequence" => "{$s}160",
                "name" => "StringMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}StringGauge" => [
                "sequence" => "{$s}170",
                "name" => "StringGauge",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getInstrumentPartsAndAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * InstrumentPartsAndAccessories => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_InstrumentPartsAndAccessories_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_InstrumentPartsAndAccessories" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "InstrumentPartsAndAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}60",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MusicalStyle" => [
                "sequence" => "{$s}130",
                "name" => "MusicalStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getKeyboardInstruments()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * KeyboardInstruments => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_KeyboardInstruments_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_KeyboardInstruments" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "KeyboardInstruments",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getMiscWorldInstruments()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * MiscWorldInstruments => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_MiscWorldInstruments_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_MiscWorldInstruments" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "MiscWorldInstruments",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}60",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MusicalStyle" => [
                "sequence" => "{$s}130",
                "name" => "MusicalStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getPercussionInstruments()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * PercussionInstruments => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_PercussionInstruments_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_PercussionInstruments" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "PercussionInstruments",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}60",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MusicalStyle" => [
                "sequence" => "{$s}130",
                "name" => "MusicalStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSoundAndRecordingEquipment()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * SoundAndRecordingEquipment => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_SoundAndRecordingEquipment_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_SoundAndRecordingEquipment" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "SoundAndRecordingEquipment",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}60",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MusicalStyle" => [
                "sequence" => "{$s}130",
                "name" => "MusicalStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getStringedInstruments()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MusicalInstruments => 10
         * ProductType => 10
         * StringedInstruments => 80
         */
        $s = "100\\10\\10\\80\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_ProductType_StringedInstruments_";

        $this->attributes = [
            "ProductData_MusicalInstruments_ProductType_StringedInstruments" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "StringedInstruments",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Size" => [
                "sequence" => "{$s}40",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InstrumentKey" => [
                "sequence" => "{$s}60",
                "name" => "InstrumentKey",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Range" => [
                "sequence" => "{$s}80",
                "name" => "Range",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Alto",
                                "Baritone",
                                "Bass",
                                "Mezzo Soprano",
                                "Soprano",
                                "Tenor",
                            ],
                    ],
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}120",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MusicalStyle" => [
                "sequence" => "{$s}130",
                "name" => "MusicalStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_MusicalInstruments_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
