<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Motorcycles extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_VEHICLES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PROTECTIVE_CLOTHING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HELMETS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RIDING_BOOTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GLOVES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PARTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Motorcycles';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        $this->attributes['DescriptionData_MfrPartNumber'] = [
            'sequence' => '30\160',
            'name' => 'MfrPartNumber',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];

        switch ($this->subCategory) {
            case "Vehicles":
                $this->attributes = array_merge($this->attributes, $this->getVehicles());
                break;
            case "ProtectiveClothing":
                $this->attributes = array_merge($this->attributes, $this->getProtectiveClothing());
                break;
            case "Helmets":
                $this->attributes = array_merge($this->attributes, $this->getHelmets());
                break;
            case "RidingBoots":
                $this->attributes = array_merge($this->attributes, $this->getRidingBoots());
                break;
            case "Gloves":
                $this->attributes = array_merge($this->attributes, $this->getGloves());
                break;
            case "Accessories":
                $this->attributes = array_merge($this->attributes, $this->getAccessories());
                break;
            case "Parts":
                $this->attributes = array_merge($this->attributes, $this->getParts());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_";
        $common = [
            "{$i}CareInstructions" => [
                "sequence" => "{$s}30",
                "name" => "CareInstructions",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}100",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}110\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}110\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Size",
                                "SizeColor",
                            ],
                    ],
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getVehicles()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * Vehicles => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_Vehicles_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_Vehicles" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Vehicles",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}BackSuspensionDescription" => [
                "sequence" => "{$s}20",
                "name" => "BackSuspensionDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BackWheelDescription" => [
                "sequence" => "{$s}30",
                "name" => "BackWheelDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DriveSystem" => [
                "sequence" => "{$s}50",
                "name" => "DriveSystem",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}EngineType" => [
                "sequence" => "{$s}60",
                "name" => "EngineType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FrontSuspensionDescription" => [
                "sequence" => "{$s}80",
                "name" => "FrontSuspensionDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
            ],
            "{$i}FrontWheelDescription" => [
                "sequence" => "{$s}100",
                "name" => "FrontWheelDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
            ],
            "{$i}FuelCapacity" => [
                "sequence" => "{$s}120",
                "name" => "FuelCapacity",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "attribute" => "{$i}FuelCapacity_unitOfMeasure_VolumeUnitOfMeasure"
            ],
            "{$i}FuelType" => [
                "sequence" => "{$s}150",
                "name" => "FuelType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}IgnitionSystemType" => [
                "sequence" => "{$s}160",
                "name" => "IgnitionSystemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}180",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getProtectiveClothing()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * ProtectiveClothing => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_ProtectiveClothing_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_ProtectiveClothing" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "ProtectiveClothing",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}ClosureType" => [
                "sequence" => "{$s}30",
                "name" => "ClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FitType" => [
                "sequence" => "{$s}40",
                "name" => "FitType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InnerMaterialType" => [
                "sequence" => "{$s}60",
                "name" => "InnerMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InsoleMaterialType" => [
                "sequence" => "{$s}80",
                "name" => "InsoleMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialComposition" => [
                "sequence" => "{$s}100",
                "name" => "MaterialComposition",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
            ],
            "{$i}SleeveLength" => [
                "sequence" => "{$s}120",
                "name" => "SleeveLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}SleeveLength_unitOfMeasure_ClothingSizeUnitOfMeasure"
            ],
            "{$i}WaistSize" => [
                "sequence" => "{$s}140",
                "name" => "PositiveDimension",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}WaistSize_unitOfMeasure_ClothingSizeUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getHelmets()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * Helmets => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_Helmets_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_Helmets" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "Helmets",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}ClosureType" => [
                "sequence" => "{$s}30",
                "name" => "ClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FitType" => [
                "sequence" => "{$s}40",
                "name" => "FitType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InnerMaterialType" => [
                "sequence" => "{$s}60",
                "name" => "InnerMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InsoleMaterialType" => [
                "sequence" => "{$s}80",
                "name" => "InsoleMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialComposition" => [
                "sequence" => "{$s}100",
                "name" => "MaterialComposition",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getRidingBoots()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * RidingBoots => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_RidingBoots_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_RidingBoots" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "RidingBoots",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}ClosureType" => [
                "sequence" => "{$s}30",
                "name" => "ClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FitType" => [
                "sequence" => "{$s}40",
                "name" => "FitType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InnerMaterialType" => [
                "sequence" => "{$s}60",
                "name" => "InnerMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InsoleMaterialType" => [
                "sequence" => "{$s}80",
                "name" => "InsoleMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialComposition" => [
                "sequence" => "{$s}100",
                "name" => "MaterialComposition",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
            ],
            "{$i}Seasons" => [
                "sequence" => "{$s}120",
                "name" => "Seasons",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SoleMaterial" => [
                "sequence" => "{$s}140",
                "name" => "SoleMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getGloves()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * Gloves => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_Gloves_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_Gloves" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "Gloves",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}ClosureType" => [
                "sequence" => "{$s}30",
                "name" => "ClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FitType" => [
                "sequence" => "{$s}40",
                "name" => "FitType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InnerMaterialType" => [
                "sequence" => "{$s}60",
                "name" => "InnerMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InsoleMaterialType" => [
                "sequence" => "{$s}80",
                "name" => "InsoleMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialComposition" => [
                "sequence" => "{$s}100",
                "name" => "MaterialComposition",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
            ],
            "{$i}Seasons" => [
                "sequence" => "{$s}120",
                "name" => "Seasons",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * Accessories => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_Accessories_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_Accessories" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "Accessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}30",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getParts()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Motorcycles => 10
         * ProductType => 10
         * Parts => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_ProductType_Parts_";

        $this->attributes = [
            "ProductData_Motorcycles_ProductType_Parts" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "Parts",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AreBatteriesIncluded" => [
                "sequence" => "{$s}10",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}ClosureType" => [
                "sequence" => "{$s}30",
                "name" => "ClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubVehicles()
    {
        $i = "ProductData_Motorcycles_ProductType_Vehicles_";
        $subAttributes = [
            "{$i}FuelCapacity_unitOfMeasure_VolumeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "cubic-cm",
                                "cubic-ft",
                                "cubic-in",
                                "cubic-m",
                                "cubic-yd",
                                "cup",
                                "fluid-oz",
                                "gallon",
                                "liter",
                                "milliliter",
                                "ounce",
                                "pint",
                                "quart",
                                "liters",
                                "deciliters",
                                "centiliters",
                                "milliliters",
                                "microliters",
                                "nanoliters",
                                "picoliters",
                            ],
                    ],
                "default" => "liters"
            ],
        ];
        return $subAttributes;
    }

    public function getSubProtectiveClothing()
    {
        $i = "ProductData_Motorcycles_ProductType_ProtectiveClothing_";
        $subAttributes = [
            "{$i}SleeveLength_unitOfMeasure_ClothingSizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "IN",
                                1 => "CM",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WaistSize_unitOfMeasure_ClothingSizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "IN",
                                1 => "CM",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Motorcycles_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
