<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Miscellaneous extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_MISC_TYPE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Miscellaneous';
        $this->data["ProductData_{$this->category}_ProductType"] = $subCategory;
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Miscellaneous => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Miscellaneous_";
        $common = [
            "{$i}ProductType" => [
                "sequence" => "{$s}20",
                "name" => "ProductType",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false,
                "restriction" => [
                    "optionValues" => [
                        "Antiques",
                        "Art",
                        "Car_Parts_and_Accessories",
                        "Coins",
                        "Collectibles",
                        "Crafts",
                        "Event_Tickets",
                        "Flowers",
                        "Gifts_and_Occasions",
                        "Gourmet_Food_and_Wine",
                        "Hobbies",
                        "Home_Furniture_and_Decor",
                        "Home_Lighting_and_Lamps",
                        "Home_Organizers_and_Storage",
                        "Jewelry_and_Gems",
                        "Luggage",
                        "Major_Home_Appliances",
                        "Medical_Supplies",
                        "Motorcycles",
                        "Musical_Instruments",
                        "Pet_Supplies",
                        "Pottery_and_Glass",
                        "Prints_and_Posters",
                        "Scientific_Supplies",
                        "Sporting_and_Outdoor_Goods",
                        "Sports_Memorabilia",
                        "Stamps",
                        "Teaching_and_School_Supplies",
                        "Watches",
                        "Wholesale_and_Industrial",
                        "Misc_Other",
                    ],
                ],
            ],
            "{$i}ProductCategory" => [
                "sequence" => "{$s}20",
                "name" => "ProductCategory",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "visible" => false,
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Antiques",
                                "Art",
                                "Car_Parts_and_Accessories",
                                "Coins",
                                "Collectibles",
                                "Crafts",
                                "Event_Tickets",
                                "Flowers",
                                "Gifts_and_Occasions",
                                "Gourmet_Food_and_Wine",
                                "Hobbies",
                                "Home_Furniture_and_Decor",
                                "Home_Lighting_and_Lamps",
                                "Home_Organizers_and_Storage",
                                "Jewelry_and_Gems",
                                "Luggage",
                                "Major_Home_Appliances",
                                "Medical_Supplies",
                                "Motorcycles",
                                "Musical_Instruments",
                                "Pet_Supplies",
                                "Pottery_and_Glass",
                                "Prints_and_Posters",
                                "Scientific_Supplies",
                                "Sporting_and_Outdoor_Goods",
                                "Sports_Memorabilia",
                                "Stamps",
                                "Teaching_and_School_Supplies",
                                "Watches",
                                "Wholesale_and_Industrial",
                                "Misc_Other",
                            ],
                    ],
            ],
            "{$i}ProductSubcategory" => [
                "sequence" => "{$s}30",
                "name" => "ProductSubcategory",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Decorative_Arts",
                                "Furniture",
                                "Rugs_Carpets",
                                "Silver",
                                "Textiles_Linens",
                                "Drawings",
                                "Mixed_Media",
                                "Paintings",
                                "Sculptures_Carvings",
                                "Car_Accessories",
                                "Car_Parts",
                                "Car_Performance",
                                "Truck_Accessories",
                                "Truck_Parts",
                                "Truck_Performance",
                                "Coins_US",
                                "Coins_World",
                                "Paper_Money_US",
                                "Paper_Money_World",
                                "Scripophily",
                                "Autographs",
                                "Comics",
                                "Holiday_Seasonal",
                                "Militaria",
                                "Trading_Cards",
                                "Corsages",
                                "Exotics",
                                "Flowering_Plants",
                                "Green_Plants",
                                "Mixed_Arrangements",
                                "Single_Flower",
                                "Anniversary",
                                "Birthday",
                                "Holiday",
                                "Wedding",
                                "Cheese",
                                "Wine",
                                "Furniture",
                                "Decor",
                                "Lighting",
                                "Lamps",
                                "Indoor",
                                "Outdoor",
                                "Jewelry",
                                "Gems",
                                "Garment_Bags",
                                "Duffle_Bags",
                                "Kitchen",
                                "Laundry",
                                "Hospital_Supplies",
                                "Home_Health",
                                "Motorcyles",
                                "Motorcycle_Parts",
                                "Motorcycle_Protective_Gear",
                                "Pet_Care",
                                "Pet_Food",
                                "Pet_Toys",
                                "Glass",
                                "Pottery",
                                "Posters",
                                "Prints",
                                "Lab_Supplies",
                                "Sporting_Goods",
                                "Outdoor_Gear",
                                "Marine",
                                "Autographs",
                                "Trading_Cards",
                                "Stamps_US",
                                "Stamps_World",
                                "Preschool",
                                "K-12",
                                "Special_Needs",
                                "Men",
                                "Women",
                                "Kids",
                                "Agriculture",
                                "Architecture",
                                "Construction",
                                "Marine",
                                "Metalworking",
                                "Other",
                            ],
                    ],
            ],
            "{$i}Manufacturer" => [
                "sequence" => "{$s}40",
                "name" => "Manufacturer",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
            ],
            "{$i}Keywords" => [
                "sequence" => "{$s}45",
                "name" => "Keywords",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}50",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}60",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
            ],
            "{$i}EventDate" => [
                "sequence" => "{$s}65",
                "name" => "EventDate",
                "minOccurs" => "0",
                "dataType" => "dateTime",
            ],
            "{$i}ModelName" => [
                "sequence" => "{$s}80",
                "name" => "ModelName",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}90",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
            ],
            "{$i}MfrPartNumber" => [
                "sequence" => "{$s}100",
                "name" => "MfrPartNumber",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Miscellaneous_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
