<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class MechanicalFasteners extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_MECHANICAL_FASTENERS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'MechanicalFasteners';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "MechanicalFasteners":
                $this->attributes = array_merge($this->attributes, $this->getMechanicalFasteners());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * MechanicalFasteners => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MechanicalFasteners_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getMechanicalFasteners()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * MechanicalFasteners => 10
         * ProductType => 10
         * MechanicalFasteners => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_MechanicalFasteners_ProductType_MechanicalFasteners_";

        $this->attributes = [
            "ProductData_MechanicalFasteners_ProductType_MechanicalFasteners" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "MechanicalFasteners",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Color" => [
                "sequence" => "{$s}10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleGrooveDepth" => [
                "sequence" => "{$s}20",
                "name" => "CompatibleGrooveDepth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CompatibleGrooveDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CompatibleGrooveDiameter" => [
                "sequence" => "{$s}30",
                "name" => "CompatibleGrooveDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CompatibleGrooveDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CompatibleGrooveWidth" => [
                "sequence" => "{$s}40",
                "name" => "CompatibleGrooveWidth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CompatibleGrooveWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CompatibleWithInsideDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CompatibleWithInsideDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CompatibleWithInsideDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DriveSystem" => [
                "sequence" => "{$s}100",
                "name" => "DriveSystem",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HeadDiameter" => [
                "sequence" => "{$s}150",
                "name" => "HeadDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}HeadDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HeadDiameterTolerance" => [
                "sequence" => "{$s}160",
                "name" => "HeadDiameterTolerance",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}HeadDiameterTolerance_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HeadHeight" => [
                "sequence" => "{$s}170",
                "name" => "HeadHeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}HeadHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HeadHeightTolerance" => [
                "sequence" => "{$s}180",
                "name" => "HeadHeightTolerance",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}HeadHeightTolerance_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}InsideDiameter" => [
                "sequence" => "{$s}200",
                "name" => "InsideDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}InsideDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ItemDepth" => [
                "sequence" => "{$s}250",
                "name" => "ItemDepth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}ItemDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ItemDiameter" => [
                "sequence" => "{$s}260",
                "name" => "ItemDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}ItemDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}350",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubMechanicalFasteners()
    {
        $i = "ProductData_MechanicalFasteners_ProductType_MechanicalFasteners_";
        $subAttributes = [
            "{$i}CompatibleGrooveDepth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}CompatibleGrooveDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}CompatibleGrooveWidth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}CompatibleWithInsideDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HeadDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HeadDiameterTolerance_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HeadHeight_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HeadHeightTolerance_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}InsideDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}ItemDepth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}ItemDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_MechanicalFasteners_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
