<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class LuxuryBeauty extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_LUXURY_BEAUTY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'LuxuryBeauty';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "LuxuryBeauty":
                $this->attributes = array_merge($this->attributes, $this->getLuxuryBeauty());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * LuxuryBeauty => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LuxuryBeauty_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "SizeName",
                                "ColorName",
                                "SizeName-ColorName",
                                "Scent",
                                "Size-Scent",
                            ],
                    ],
            ],
            "{$i}Size" => [
                "sequence" => "{$s}50",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScentName" => [
                "sequence" => "{$s}70",
                "name" => "ScentName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}90",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Flavor" => [
                "sequence" => "{$s}150",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Specialty" => [
                "sequence" => "{$s}170",
                "name" => "Specialty",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SkinType" => [
                "sequence" => "{$s}270",
                "name" => "SkinType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HairType" => [
                "sequence" => "{$s}280",
                "name" => "HairType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}350",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getLuxuryBeauty()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LuxuryBeauty => 10
         * ProductType => 10
         * LuxuryBeauty => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LuxuryBeauty_ProductType_LuxuryBeauty_";

        $attributes = [
            "ProductData_LuxuryBeauty_ProductType_LuxuryBeauty" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "LuxuryBeauty",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_LuxuryBeauty_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
