<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Luggage extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_LUGGAGE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Luggage';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Luggage":
                $this->attributes = array_merge($this->attributes, $this->getLuggage());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Luggage => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Luggage_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "SizeName",
                                "ColorName",
                                "SizeName-ColorName",
                            ],
                    ],
            ],
            "{$i}Model" => [
                "sequence" => "{$s}30",
                "name" => "Model",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelName" => [
                "sequence" => "{$s}40",
                "name" => "ModelName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}50",
                "name" => "SpecialFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}60",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClosureType" => [
                "sequence" => "{$s}70",
                "name" => "ClosureType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ShellType" => [
                "sequence" => "{$s}80",
                "name" => "ShellType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}280",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}380",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getLuggage()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Luggage => 10
         * ProductType => 10
         * Luggage => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Luggage_ProductType_Luggage_";

        $attributes = [
            "ProductData_Luggage_ProductType_Luggage" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Luggage",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Luggage_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
