<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Lighting extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_LIGHTS_AND_FIXTURES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LIGHTING_ACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LIGHT_BULBS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Lighting';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "LightsAndFixtures":
                $this->attributes = array_merge($this->attributes, $this->getLightsAndFixtures());
                break;
            case "LightingAccessories":
                $this->attributes = array_merge($this->attributes, $this->getLightingAccessories());
                break;
            case "LightBulbs":
                $this->attributes = array_merge($this->attributes, $this->getLightBulbs());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Lighting => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Lighting_";
        $common = [
            "{$i}DisplayDepth" => [
                "sequence" => "{$s}1000",
                "name" => "DisplayDepth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayDiameter" => [
                "sequence" => "{$s}1100",
                "name" => "DisplayDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayHeight" => [
                "sequence" => "{$s}1200",
                "name" => "DisplayHeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}1300",
                "name" => "DisplayLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayWeight" => [
                "sequence" => "{$s}1400",
                "name" => "DisplayWeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"
            ],
            "{$i}DisplayWidth" => [
                "sequence" => "{$s}1500",
                "name" => "DisplayWidth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) && !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getLightsAndFixtures()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Lighting => 10
         * ProductType => 10
         * LightsAndFixtures => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Lighting_ProductType_LightsAndFixtures_";

        $attributes = [
            "ProductData_Lighting_ProductType_LightsAndFixtures" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "LightsAndFixtures",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "Color",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}100",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FanBladeColor" => [
                "sequence" => "{$s}200",
                "name" => "FanBladeColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LightingMethod" => [
                "sequence" => "{$s}300",
                "name" => "LightingMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}450",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}500",
                "name" => "SpecialFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SwitchStyle" => [
                "sequence" => "{$s}600",
                "name" => "SwitchStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getLightingAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Lighting => 10
         * ProductType => 10
         * LightingAccessories => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Lighting_ProductType_LightingAccessories_";

        $attributes = [
            "ProductData_Lighting_ProductType_LightingAccessories" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "LightingAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Color" => [
                "sequence" => "{$s}100",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}IncludedComponent" => [
                "sequence" => "{$s}200",
                "name" => "IncludedComponent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfStrands" => [
                "sequence" => "{$s}220",
                "name" => "NumberOfStrands",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PlugType" => [
                "sequence" => "{$s}250",
                "name" => "PlugType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PowerSource" => [
                "sequence" => "{$s}260",
                "name" => "PowerSource",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecificUses" => [
                "sequence" => "{$s}280",
                "name" => "SpecificUses",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getLightBulbs()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Lighting => 10
         * ProductType => 10
         * LightBulbs => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Lighting_ProductType_LightBulbs_";

        $attributes = [
            "ProductData_Lighting_ProductType_LightBulbs" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "LightBulbs",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "Wattage",
                            ],
                    ],
            ],
            "{$i}BeamAngle" => [
                "sequence" => "{$s}20",
                "name" => "BeamAngle",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}BeamAngle_unitOfMeasure_DegreeUnitOfMeasure"
            ],
            "{$i}BulbDiameter" => [
                "sequence" => "{$s}30",
                "name" => "BulbDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}BulbDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BulbLength" => [
                "sequence" => "{$s}40",
                "name" => "BulbLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}BulbLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BulbSpecialFeatures" => [
                "sequence" => "{$s}50",
                "name" => "BulbSpecialFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BulbSwitchingCycles" => [
                "sequence" => "{$s}60",
                "name" => "BulbSwitchingCycles",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}BulbType" => [
                "sequence" => "{$s}70",
                "name" => "BulbType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BulbWattage" => [
                "sequence" => "{$s}80",
                "name" => "BulbWattage",
                "minOccurs" => "0",
                "dataType" => "Dimension",
            ],
            "{$i}Voltage" => [
                "sequence" => "{$s}250",
                "name" => "Voltage",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}Wattage" => [
                "sequence" => "{$s}270",
                "name" => "Wattage",
                "minOccurs" => "0",
                "dataType" => "Dimension",
            ],
        ];
        return $attributes;
    }

    public function getSubLightBulbs()
    {
        $i = "ProductData_Lighting_ProductType_LightBulbs_";
        $subAttributes = [
            "{$i}BeamAngle_unitOfMeasure_DegreeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                "degrees",
                                "radians",
                            ],
                    ],
                "default" => "degrees"
            ],
            "{$i}BulbDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}BulbLength_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Lighting_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "GR",
                    1 => "KG",
                    2 => "OZ",
                    3 => "LB",
                    4 => "MG",
                ],
            ],
            "default" => "KG"
        ];

        return $subAttributes;
    }
}
