<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Jewelry extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_WATCH = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FASHION_NECKLACE_BRACELET_ANKLET = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FASHION_RING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FASHION_EARRING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FASHION_OTHER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FINE_NECKLACE_BRACELET_ANKLET = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FINE_RING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FINE_EARRING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FINE_OTHER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Jewelry';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Watch":
                $this->attributes = array_merge($this->attributes, $this->getWatch());
                break;
            case "FashionNecklaceBraceletAnklet":
                $this->attributes = array_merge($this->attributes, $this->getFashionNecklaceBraceletAnklet());
                break;
            case "FashionRing":
                $this->attributes = array_merge($this->attributes, $this->getFashionRing());
                break;
            case "FashionEarring":
                $this->attributes = array_merge($this->attributes, $this->getFashionEarring());
                break;
            case "FashionOther":
                $this->attributes = array_merge($this->attributes, $this->getFashionOther());
                break;
            case "FineNecklaceBraceletAnklet":
                $this->attributes = array_merge($this->attributes, $this->getFineNecklaceBraceletAnklet());
                break;
            case "FineRing":
                $this->attributes = array_merge($this->attributes, $this->getFineRing());
                break;
            case "FineEarring":
                $this->attributes = array_merge($this->attributes, $this->getFineEarring());
                break;
            case "FineOther":
                $this->attributes = array_merge($this->attributes, $this->getFineOther());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Jewelry => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_";

        $common = [
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}StyleName" => [
                "sequence" => "{$s}30",
                "name" => "StyleName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}RegionOfOrigin" => [
                "sequence" => "{$s}40",
                "name" => "RegionOfOrigin",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}50",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeMap" => [
                "sequence" => "{$s}51",
                "name" => "SizeMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Warnings" => [
                "sequence" => "{$s}60",
                "name" => "Warnings",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WarrantyType" => [
                "sequence" => "{$s}70",
                "name" => "WarrantyType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}80",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ]
        ];

        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getWatch()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * Watch => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_Watch_";

        $attributes = [
            "ProductData_Jewelry_ProductType_Watch" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Watch",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ]
                ]
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "BandColor",
                        "Color",
                        "StyleName",
                        "SizeName",
                        "SizeName-ColorName"
                    ]
                ]
            ],
            "{$i}BandColor" => [
                "sequence" => "{$s}30",
                "name" => "BandColor",
                "minOccur" => "0",
                "dataType" => "FortyStringNotNull",
                "length" => "1:40",
            ],
            "{$i}BandMaterial" => [
                "sequence" => "{$s}40",
                "name" => "BandMaterial",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BandLength" => [
                "sequence" => "{$s}50",
                "name" => "BandLength",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BandWidth" => [
                "sequence" => "{$s}60",
                "name" => "BandWidth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimensionFourDecimal",
                "attribute" => $i . "BandWidth_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}BatteryAverageLife" => [
                "sequence" => "{$s}70",
                "name" => "BatteryAverageLife",
                "minOccur" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "2",
                "minExclusive" => "0.00",
            ],
            "{$i}BatteryAverageLifeStandby" => [
                "sequence" => "{$s}80",
                "name" => "BatteryAverageLifeStandby",
                "minOccur" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "2",
                "minExclusive" => "0.00",
            ],
            "{$i}BatteryChargeTime" => [
                "sequence" => "{$s}90",
                "name" => "BatteryChargeTime",
                "minOccur" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "2",
                "minExclusive" => "0.00",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}100",
                "name" => "CollectionName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}110",
                "name" => "ClaspType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CaseMaterial" => [
                "sequence" => "{$s}120",
                "name" => "CaseMaterial",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CaseSizeThickness" => [
                "sequence" => "{$s}130",
                "name" => "CaseSizeThickness",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "CaseSizeThickness_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}CaseSizeDiameter" => [
                "sequence" => "{$s}140",
                "name" => "CaseSizeDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "CaseSizeDiameter_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}LifeStyle" => [
                "sequence" => "{$s}150",
                "name" => "LifeStyle",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}SpecificUsesForProduct" => [
                "sequence" => "{$s}160",
                "name" => "SpecificUsesForProduct",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}170",
                "name" => "MetalStamp",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}180",
                "name" => "SettingType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DialColor" => [
                "sequence" => "{$s}190",
                "name" => "DialColor",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DialColorMap" => [
                "sequence" => "{$s}200",
                "name" => "DialColorMap",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BezelMaterial" => [
                "sequence" => "{$s}210",
                "name" => "BezelMaterial",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BezelFunction" => [
                "sequence" => "{$s}220",
                "name" => "BezelFunction",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}GemType" => [
                "sequence" => "{$s}230",
                "name" => "GemType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Crystal" => [
                "sequence" => "{$s}240",
                "name" => "Crystal",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MovementType" => [
                "sequence" => "{$s}250",
                "name" => "MovementType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CalendarType" => [
                "sequence" => "{$s}260",
                "name" => "CalendarType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}WaterResistantDepth" => [
                "sequence" => "{$s}270",
                "name" => "WaterResistantDepth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "WaterResistantDepth_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}ResaleType" => [
                "sequence" => "{$s}280",
                "name" => "ResaleType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}WarrantyType" => [
                "sequence" => "{$s}290",
                "name" => "WarrantyType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}IncludedItems" => [
                "sequence" => "{$s}300",
                "name" => "IncludedItems",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}310",
                "name" => "SellerWarrantyDescription",
                "minOccur" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizeMap" => [
                "sequence" => "{$s}320",
                "name" => "SizeMap",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}330",
                "name" => "EstatePeriod",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}340",
                "name" => "CountryOfOrigin",
                "minOccur" => "0",
                "dataType" => "CountryOfOriginType",
                "length" => "1:50",
            ],
            "{$i}RegionOfOrigin" => [
                "sequence" => "{$s}350",
                "name" => "RegionOfOrigin",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}360",
                "name" => "ItemShape",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}370",
                "name" => "SpecialFeatures",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}380",
                "name" => "DisplayLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $i . "DisplayLength_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}DisplayType" => [
                "sequence" => "{$s}390",
                "name" => "DisplayType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DisplayVolume" => [
                "sequence" => "{$s}400",
                "name" => "DisplayVolume",
                "minOccurs" => "0",
                "dataType" => "VolumeDimension",
                "attribute" => $i . "DisplayVolume_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}DisplayWeight" => [
                "sequence" => "{$s}410",
                "name" => "DisplayWeight",
                "minOccurs" => "0",
                "dataType" => "WeightDimension",
                "attribute" => $i . "DisplayWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}MaximumWaterPressure" => [
                "sequence" => "{$s}420",
                "name" => "MaximumWaterPressure",
                "minOccurs" => "0",
                "dataType" => "PressureDimension",
                "attribute" => $i . "MaximumWaterPressure_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}430",
                "name" => "ModelYear",
                "minOccur" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4"
            ],
            "{$i}Warnings" => [
                "sequence" => "{$s}440",
                "name" => "Warnings",
                "minOccur" => "0",
                "dataType" => "LongStringNotNull",
                "length" => "1:500",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}450",
                "name" => "Season",
                "minOccur" => "0",
                "dataType" => "HundredString",
                "maxLength" => "50",
            ],
            "{$i}PowerSource" => [
                "sequence" => "{$s}460",
                "name" => "PowerSource",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SportType" => [
                "sequence" => "{$s}470",
                "name" => "SportType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ManufacturerWarrantyType" => [
                "sequence" => "{$s}480",
                "name" => "ManufacturerWarrantyType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MfgWarrantyDescriptionLabor" => [
                "sequence" => "{$s}490",
                "name" => "MfgWarrantyDescriptionLabor",
                "minOccur" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}MfgWarrantyDescriptionParts" => [
                "sequence" => "{$s}500",
                "name" => "MfgWarrantyDescriptionParts",
                "minOccur" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}510",
                "name" => "AreBatteriesIncluded",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:1000",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}520",
                "name" => "AreBatteriesRequired",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:1000",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}530",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}530",
                "name" => "NumberOfBatteries",
                "minOccur" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}540",
                "name" => "DepartmentName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SubjectCharacter" => [
                "sequence" => "{$s}550",
                "name" => "SubjectCharacter",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DistributionDesignation" => [
                "sequence" => "{$s}555",
                "name" => "DistributionDesignation",
                "minOccur" => "0",
                "dataType" => "DistributionDesignationValues",
                "length" => "1:50",
            ],
            "{$i}Codabar" => [
                "sequence" => "{$s}560",
                "name" => "Codabar",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}GradeRating" => [
                "sequence" => "{$s}570",
                "name" => "GradeRating",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}AuthenticatedBy" => [
                "sequence" => "{$s}580",
                "name" => "AuthenticatedBy",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
        ];

        return $attributes;
    }

    public function getFashionNecklaceBraceletAnklet()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FashionNecklaceBraceletAnklet => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FashionNecklaceBraceletAnklet_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FashionNecklaceBraceletAnklet" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FashionNecklaceBraceletAnklet",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "Length",
                        "MetalType",
                        "Length-MetalType",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                        "Color-DisplayLength",
                    ],
                ],
            ],
            "{$i}VariationData_Length" => [
                "sequence" => "{$s}10\\30",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "VariationData_Length_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\40",
                "name" => "MetalType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}50",
                "name" => "ClaspType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}60",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}70",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}80",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}90",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}100",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}110",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}120",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ChainDescription" => [
                "sequence" => "{$s}130",
                "name" => "ChainDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}140",
                "name" => "EstatePeriod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}150",
                "name" => "GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}160",
                "name" => "StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}160",
                "name" => "StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}170",
                "name" => "StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}180",
                "name" => "StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}190",
                "name" => "StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}200",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}210",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}220",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}230",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}240",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}250",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}260",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}270",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}280",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}290",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}300",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}310",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}320",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}330",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}340",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}350",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}360",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}370",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}380",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}390",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}400",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}410",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}420",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}430",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}440",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}450\\10",
                "name" => "CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}450\\20",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}460",
                "name" => "CollectionName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}470",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}480",
                "name" => "DepartmentName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemLengthDescription" => [
                "sequence" => "{$s}490",
                "name" => "ItemLengthDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}500",
                "name" => "ItemShape",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}510",
                "name" => "ItemStyling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}520",
                "name" => "OccasionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}530",
                "name" => "PackageTypeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}540",
                "name" => "PatternName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}550",
                "name" => "SizingLowerRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}560",
                "name" => "SizingUpperRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}TotalDiamondWeight" => [
                "sequence" => "{$s}570",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}580",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}590",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}GemType" => [
                "sequence" => "{$s}600",
                "name" => "GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
        ];

        return $attributes;
    }

    public function getFashionRing()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FashionRing => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FashionRing_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FashionRing" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FashionRing",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "RingSize",
                        "MetalType",
                        "Color",
                        "MetalType-RingSize",
                        "Diameter",
                        "DisplayWeight",
                        "Color-RingSize",
                    ],
                ],
            ],
            "{$i}VariationData_RingSize" => [
                "sequence" => "{$s}10\\30",
                "name" => "RingSize",
                "minOccurs" => "0",
                "dataType" => "normalizedString",
                "length" => "1:13",
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\40",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "normalizedString",
                "length" => "1:50",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}50",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}60",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}70",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}80",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}90",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}100",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Length" => [
                "sequence" => "{$s}110",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}120",
                "name" => "EstatePeriod",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}130",
                "name" => "GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}140",
                "name" => "StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}150",
                "name" => "StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}160",
                "name" => "StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}170",
                "name" => "StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}180",
                "name" => "StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}190",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}200",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}210",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}220",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}230",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}240",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}250",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}260",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}270",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}280",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}290",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}300",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}310",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}320",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}340",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}350",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}360",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}370",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}380",
                "name" => "OccasionType",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}390",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}400",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}410",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}420",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}430",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}440",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}450\\10",
                "name" => "CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}450\\20",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}460",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}470",
                "name" => "ClaspType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}480",
                "name" => "CollectionName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}490",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}500",
                "name" => "DepartmentName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}510",
                "name" => "ItemStyling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}520",
                "name" => "OccasionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}530",
                "name" => "PackageTypeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}540",
                "name" => "PatternName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}550",
                "name" => "SizingLowerRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}560",
                "name" => "SizingUpperRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}TotalDiamondWeight" => [
                "sequence" => "{$s}570",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}580",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}590",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
        ];

        return $attributes;
    }

    public function getFashionEarring()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FashionEarring => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FashionEarring_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FashionEarring" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FashionEarring",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "MetalType",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                    ],
                ],
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\30",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "normalizedString",
                "length" => "1:50",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}40",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}50",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}60",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}70",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}80",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}90",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Length" => [
                "sequence" => "{$s}100",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}101",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}102",
                "name" => "Stone_GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}103",
                "name" => "Stone_StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}104",
                "name" => "Stone_StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}105",
                "name" => "Stone_StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}106",
                "name" => "Stone_StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}107",
                "name" => "Stone_StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}108",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}109",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}110",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}111",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}112",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}113",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}114",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}115",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}116",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}117",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}118",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}119",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}120",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}121",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}122",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}123",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}124",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}125",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}126",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}127",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}128",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}129",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}130",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}132",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}133",
                "name" => "Certificate_CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}134",
                "name" => "Certificate_CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}135",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}136",
                "name" => "ClaspType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}137",
                "name" => "CollectionName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}138",
                "name" => "ColorMap",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}139",
                "name" => "DepartmentName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}141",
                "name" => "ItemShape",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}142",
                "name" => "ItemStyling",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}143",
                "name" => "OccasionType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}144",
                "name" => "PackageTypeName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}145",
                "name" => "PatternName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}146",
                "name" => "SizingLowerRange",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}147",
                "name" => "SizingUpperRange",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}TotalDiamondWeight" => [
                "sequence" => "{$s}148",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}149",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}200",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
        ];

        return $attributes;
    }

    public function getFashionOther()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FashionOther => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FashionOther_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FashionOther" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FashionOther",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "Length",
                        "MetalType",
                        "Length-MetalType",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                    ],
                ],
            ],
            "{$i}VariationData_Length" => [
                "sequence" => "{$s}10\\30",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\40",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}50",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}60",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}70",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}80",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}90",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}100",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}101",
                "name" => "EstatePeriod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}102",
                "name" => "Stone_GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}103",
                "name" => "Stone_StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}104",
                "name" => "Stone_StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}105",
                "name" => "Stone_StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}106",
                "name" => "Stone_StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}107",
                "name" => "Stone_StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}108",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}109",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}110",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}111",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}112",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}113",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}114",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}115",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}116",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}117",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}118",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}119",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}120",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}121",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}122",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}123",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}124",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}125",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}126",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}127",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}128",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}129",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}130",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}131",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}132",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}133",
                "name" => "Certificate_CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}134",
                "name" => "Certificate_CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}135",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}136",
                "name" => "ClaspType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}137",
                "name" => "CollectionName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}138",
                "name" => "ColorMap",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}139",
                "name" => "DepartmentName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemLengthDescription" => [
                "sequence" => "{$s}140",
                "name" => "ItemLengthDescription",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}141",
                "name" => "ItemShape",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}142",
                "name" => "ItemStyling",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}143",
                "name" => "OccasionType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}144",
                "name" => "PackageTypeName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}145",
                "name" => "PatternName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}146",
                "name" => "SizingLowerRange",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}147",
                "name" => "SizingUpperRange",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}148",
                "name" => "SettingType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}TotalDiamondWeight" => [
                "sequence" => "{$s}149",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}150",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
        ];

        return $attributes;
    }

    public function getFineNecklaceBraceletAnklet()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FineNecklaceBraceletAnklet => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FineNecklaceBraceletAnklet_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FineNecklaceBraceletAnklet" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FineNecklaceBraceletAnklet",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "Length",
                        "MetalType",
                        "SizePerPearl",
                        "TotalDiamondWeight",
                        "Length-TotalDiamondWeight",
                        "Length-SizePerPearl",
                        "MetalType-TotalDiamondWeight",
                        "MetalType-SizePerPearl",
                        "MetalStamp",
                        "GemType",
                        "GemType-MetalType",
                        "MetalType-MetalStamp",
                        "MetalType-Length",
                        "GemType-Length",
                        "StoneShape-MetalType",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                    ],
                ],
            ],
            "{$i}VariationData_Length" => [
                "sequence" => "{$s}10\\30",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\40",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}VariationData_TotalDiamondWeight" => [
                "sequence" => "{$s}10\\50",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}60",
                "name" => "ClaspType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}70",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}80",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}90",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}100",
                "name" => "Certificate_CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}101",
                "name" => "Certificate_CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}102",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}103",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}104",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}105",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}106",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}107",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ChainDescription" => [
                "sequence" => "{$s}108",
                "name" => "ChainDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}109",
                "name" => "EstatePeriod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}110",
                "name" => "Stone_GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}111",
                "name" => "Stone_StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}112",
                "name" => "Stone_StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}113",
                "name" => "Stone_StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}114",
                "name" => "Stone_StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}115",
                "name" => "Stone_StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}116",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}117",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}118",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}119",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}120",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}121",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}122",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}123",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}124",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}125",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}126",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}127",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}128",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Hallmark" => [
                "sequence" => "{$s}129",
                "name" => "Hallmark",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}130",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}131",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}132",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}133",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}134",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}135",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}136",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}137",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}138",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}139",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}140",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}141",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}142",
                "name" => "CollectionName",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}143",
                "name" => "ColorMap",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}144",
                "name" => "DepartmentName",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}ItemLengthDescription" => [
                "sequence" => "{$s}145",
                "name" => "ItemLengthDescription",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}146",
                "name" => "ItemShape",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}147",
                "name" => "ItemStyling",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}148",
                "name" => "OccasionType",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}149",
                "name" => "PackageTypeName",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}150",
                "name" => "PatternName",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}151",
                "name" => "SizingLowerRange",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}152",
                "name" => "SizingUpperRange",
                "minOccur" => "0",
                "dataType" => "LongString",
                "length" => "1:50",
            ],
        ];

        return $attributes;
    }

    public function getFineRing()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FineRing => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FineRing_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FineRing" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FineRing",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "RingSize",
                        "MetalType",
                        "SizePerPearl",
                        "TotalDiamondWeight",
                        "MetalType-RingSize",
                        "MetalType-TotalDiamondWeight",
                        "MetalType-SizePerPearl",
                        "MetalStamp",
                        "GemType",
                        "GemType-MetalType",
                        "MetalType-MetalStamp",
                        "GemType-RingSize",
                        "StoneShape-MetalType",
                        "StoneShape-RingSize",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                        "Color-RingSize",
                    ],
                ],
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\30",
                "name" => "MetalType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_TotalDiamondWeight" => [
                "sequence" => "{$s}10\\40",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}Material" => [
                "sequence" => "{$s}50",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}60",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}70",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}80\\10",
                "name" => "CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}80\\20",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}90",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}90",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}90",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}90",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}90",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Length" => [
                "sequence" => "{$s}90",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}110",
                "name" => "SizingLowerRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}120",
                "name" => "SizingUpperRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}130",
                "name" => "EstatePeriod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}140",
                "name" => "GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}150",
                "name" => "StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}160",
                "name" => "StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}170",
                "name" => "StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}180",
                "name" => "StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}190",
                "name" => "StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}200",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}210",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}220",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}230",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}230",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}240",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}250",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}260",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}270",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}280",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "normalizedString",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}290",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}300",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}310",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Hallmark" => [
                "sequence" => "{$s}320",
                "name" => "Hallmark",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}330",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}340",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}350",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}360",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}370",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}380",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}390",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}400",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}410",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}420",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}430",
                "name" => "ClaspType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}440",
                "name" => "CollectionName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}450",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}460",
                "name" => "DepartmentName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}470",
                "name" => "ItemStyling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}480",
                "name" => "OccasionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}490",
                "name" => "PackageTypeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}500",
                "name" => "PatternName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}510",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}520",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}530",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}RingSize" => [
                "sequence" => "{$s}600",
                "name" => "RingSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:13",
            ],
        ];

        return $attributes;
    }

    public function getFineEarring()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FineEarring => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FineEarring_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FineEarring" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FineEarring",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "MetalType",
                        "SizePerPearl",
                        "TotalDiamondWeight",
                        "MetalType-TotalDiamondWeight",
                        "MetalType-SizePerPearl",
                        "MetalStamp",
                        "GemType",
                        "GemType-MetalType",
                        "MetalType-MetalStamp",
                        "StoneShape-MetalType",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                    ],
                ],
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\30",
                "name" => "MetalType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_TotalDiamondWeight" => [
                "sequence" => "{$s}10\\40",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "FourDecimal",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}VariationData_GemType" => [
                "sequence" => "{$s}10\\50",
                "name" => "GemType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}50",
                "name" => "Material",
                "minOccurs" => "0",
                "maxOccurs" => "4",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "agarwood",
                        "alumide",
                        "bamboo",
                        "bodhi",
                        "ceramic",
                        "coral",
                        "crystal",
                        "enamel",
                        "epoxy",
                        "gemstone",
                        "glass",
                        "Gold Phoebe",
                        "horn",
                        "leather",
                        "metal",
                        "mineral-powder",
                        "mother-of-pearl",
                        "natural-fiber",
                        "paper",
                        "pearl",
                        "plaster",
                        "plastic",
                        "polyamide",
                        "resin",
                        "rhinestone",
                        "rosewood",
                        "rubber",
                        "sandalwood",
                        "shell",
                        "silicone",
                        "stone",
                        "synthetic-fiber",
                        "synthetic-resin",
                        "wood",

                    ]
                ]
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}60",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}70",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}80\\10",
                "name" => "CertificateType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}80\\20",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "HundredString",
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}90",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "FourDecimal",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}90",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "FourDecimal",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}90",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}90",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}90",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Length" => [
                "sequence" => "{$s}90",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}100",
                "name" => "DepartmentName",
                "minOccurs" => "1",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "womens",
                        "mens",
                        "unisex-adult",
                        "girls",
                        "boys",
                        "unisex-child"
                    ]
                ]
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}110",
                "name" => "SizingLowerRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}120",
                "name" => "SizingUpperRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}130",
                "name" => "EstatePeriod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}140",
                "name" => "GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}150",
                "name" => "StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}160",
                "name" => "StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}170",
                "name" => "StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}180",
                "name" => "StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}190",
                "name" => "StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}200",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}210",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}220",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}230",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}240",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}250",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}260",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}270",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}280",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}290",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}300",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}310",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Hallmark" => [
                "sequence" => "{$s}320",
                "name" => "Hallmark",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}330",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}340",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}350",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}360",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}370",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}380",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}390",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}400",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}410",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}420",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}430",
                "name" => "ClaspType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}440",
                "name" => "CollectionName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}450",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}460",
                "name" => "DepartmentName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}470",
                "name" => "ItemStyling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}480",
                "name" => "OccasionType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}490",
                "name" => "PackageTypeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}500",
                "name" => "PatternName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}510",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}520",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}530",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
        ];

        return $attributes;
    }

    public function getFineOther()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FineOther => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Jewelry_ProductType_FineOther_";

        $attributes = [
            "ProductData_Jewelry_ProductType_FineOther" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FineOther",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "Length",
                        "MetalType",
                        "SizePerPearl",
                        "TotalDiamondWeight",
                        "Length-TotalDiamondWeight",
                        "Length-SizePerPearl",
                        "MetalType-TotalDiamondWeight",
                        "MetalType-SizePerPearl",
                        "Color",
                        "StyleName",
                        "Diameter",
                        "DisplayWeight",
                    ],
                ],
            ],
            "{$i}VariationData_Length" => [
                "sequence" => "{$s}10\\30",
                "name" => "Length",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Length_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}VariationData_MetalType" => [
                "sequence" => "{$s}10\\40",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}VariationData_TotalDiamondWeight" => [
                "sequence" => "{$s}10\\50",
                "name" => "TotalDiamondWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}Material" => [
                "sequence" => "{$s}60",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}MetalStamp" => [
                "sequence" => "{$s}70",
                "name" => "MetalStamp",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SettingType" => [
                "sequence" => "{$s}80",
                "name" => "SettingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateType" => [
                "sequence" => "{$s}90",
                "name" => "Certificate_CertificateType",
                "minOccurs" => "0",
                "dataType" => "CertificateType",
                "length" => "1:50",
            ],
            "{$i}Certificate_CertificateNumber" => [
                "sequence" => "{$s}100",
                "name" => "Certificate_CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "100",
            ],
            "{$i}TotalGemWeight" => [
                "sequence" => "{$s}101",
                "name" => "TotalGemWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}TotalMetalWeight" => [
                "sequence" => "{$s}102",
                "name" => "TotalMetalWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"
            ],
            "{$i}Diameter" => [
                "sequence" => "{$s}103",
                "name" => "Diameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Height" => [
                "sequence" => "{$s}104",
                "name" => "Height",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Height_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Width" => [
                "sequence" => "{$s}105",
                "name" => "Width",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "Width_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}EstatePeriod" => [
                "sequence" => "{$s}106",
                "name" => "EstatePeriod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_GemType" => [
                "sequence" => "{$s}107",
                "name" => "Stone_GemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCut" => [
                "sequence" => "{$s}108",
                "name" => "Stone_StoneCut",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneColor" => [
                "sequence" => "{$s}109",
                "name" => "Stone_StoneColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneClarity" => [
                "sequence" => "{$s}110",
                "name" => "Stone_StoneClarity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneShape" => [
                "sequence" => "{$s}111",
                "name" => "Stone_StoneShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneTreatmentMethod" => [
                "sequence" => "{$s}112",
                "name" => "Stone_StoneTreatmentMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneHeight" => [
                "sequence" => "{$s}113",
                "name" => "StoneHeight",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneLength" => [
                "sequence" => "{$s}114",
                "name" => "StoneLength",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWidth" => [
                "sequence" => "{$s}115",
                "name" => "StoneWidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_StoneWeight" => [
                "sequence" => "{$s}116",
                "name" => "StoneWeight",
                "minOccurs" => "0",
                "dataType" => "JewelryWeightDimension",
                "attribute" => $i . "StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_LabCreated" => [
                "sequence" => "{$s}117",
                "name" => "LabCreated",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => $i . "LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"
            ],
            "{$i}Stone_Inscription" => [
                "sequence" => "{$s}118",
                "name" => "Inscription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneDepthPercentage" => [
                "sequence" => "{$s}119",
                "name" => "StoneDepthPercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneTablePercentage" => [
                "sequence" => "{$s}120",
                "name" => "StoneTablePercentage",
                "minOccurs" => "0",
                "dataType" => "PositiveNonZeroDimension",
                "totalDigits" => "12",
                "fractionDigits" => "4",
            ],
            "{$i}Stone_StoneSymmetry" => [
                "sequence" => "{$s}121",
                "name" => "StoneSymmetry",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StonePolish" => [
                "sequence" => "{$s}122",
                "name" => "StonePolish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneGirdle" => [
                "sequence" => "{$s}123",
                "name" => "StoneGirdle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneCulet" => [
                "sequence" => "{$s}124",
                "name" => "StoneCulet",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Stone_StoneFluorescence" => [
                "sequence" => "{$s}125",
                "name" => "StoneFluorescence",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}Hallmark" => [
                "sequence" => "{$s}126",
                "name" => "Hallmark",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}127",
                "name" => "SellerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "SuperLongStringNotNull",
                "length" => "1:1000",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}128",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "FourDigitYear",
                "totalDigits" => "4",
            ],
            "{$i}Season" => [
                "sequence" => "{$s}129",
                "name" => "Season",
                "minOccurs" => "0",
                "dataType" => "HundredString",
                "maxLength" => "100",
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}130",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "CountryOfOriginType",
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown",
            ],
            "{$i}StyleKeywords" => [
                "sequence" => "{$s}131",
                "name" => "StyleKeywords",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}OccasionLifestyle" => [
                "sequence" => "{$s}132",
                "name" => "OccasionLifestyle",
                "minOccurs" => "0",
                "dataType" => "LongString",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}133",
                "name" => "AreBatteriesIncluded",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}134",
                "name" => "AreBatteriesRequired",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "maxLength" => "500",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}135",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "battery_type_2\/3A" => "battery_type_2\/3A",
                        "battery_type_4\/3A" => "battery_type_4\/3A",
                        "battery_type_4\/5A" => "battery_type_4\/5A",
                        "battery_type_9v" => "battery_type_9v",
                        "battery_type_12v" => "battery_type_12v",
                        "battery_type_a" => "battery_type_a",
                        "battery_type_a76" => "battery_type_a76",
                        "battery_type_aa" => "battery_type_aa",
                        "battery_type_aaa" => "battery_type_aaa",
                        "battery_type_aaaa" => "battery_type_aaaa",
                        "battery_type_c" => "battery_type_c",
                        "battery_type_cr123a" => "battery_type_cr123a",
                        "battery_type_cr2" => "battery_type_cr2",
                        "battery_type_cr5" => "battery_type_cr5",
                        "battery_type_d" => "battery_type_d",
                        "battery_type_lithium_ion" => "battery_type_lithium_ion",
                        "battery_type_lithium_metal" => "battery_type_lithium_metal",
                        "battery_type_L-SC" => "battery_type_L-SC",
                        "battery_type_p76" => "battery_type_p76",
                        "battery_type_product_specific" => "battery_type_product_specific",
                        "battery_type_SC" => "battery_type_SC",
                    ]
                ]
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}136",
                "name" => "NumberOfBatteries",
                "datatype" => "positiveInteger",
            ],
            "{$i}BackFinding" => [
                "sequence" => "{$s}137",
                "name" => "BackFinding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}138",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ChainType" => [
                "sequence" => "{$s}139",
                "name" => "ChainType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ClaspType" => [
                "sequence" => "{$s}140",
                "name" => "ClaspType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}CollectionName" => [
                "sequence" => "{$s}141",
                "name" => "CollectionName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}142",
                "name" => "ColorMap",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}DepartmentName" => [
                "sequence" => "{$s}143",
                "name" => "DepartmentName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemLengthDescription" => [
                "sequence" => "{$s}144",
                "name" => "ItemLengthDescription",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}145",
                "name" => "ItemShape",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}146",
                "name" => "ItemStyling",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}147",
                "name" => "OccasionType",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}148",
                "name" => "PackageTypeName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}149",
                "name" => "PatternName",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingLowerRange" => [
                "sequence" => "{$s}150",
                "name" => "SizingLowerRange",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
            "{$i}SizingUpperRange" => [
                "sequence" => "{$s}151",
                "name" => "SizingUpperRange",
                "minOccur" => "0",
                "dataType" => "StringNotNull",
                "length" => "1:50",
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {
        $subAttributes = self::SUB_ATTRIBUTES;

        //Watch

        $i = "ProductData_Jewelry_ProductType_Watch_";

        $subAttributes["{$i}BandWidth_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}CaseSizeThickness_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}CaseSizeDiameter_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}WaterResistantDepth_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayVolume_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "cubic-cm",
                    "cubic-ft",
                    "cubic-in",
                    "cubic-m",
                    "cubic-yd",
                    "cup",
                    "fluid-oz",
                    "gallon",
                    "liter",
                    "milliliter",
                    "ounce",
                    "pint",
                    "quart",
                    "liters",
                    "deciliters",
                    "centiliters",
                    "milliliters",
                    "microliters",
                    "nanoliters",
                    "picoliters",
                ],
            ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "MG",
                ],
            ],
            "default" => "KG"
        ];

        $subAttributes["{$i}MaximumWaterPressure_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "bars",
                    "psi",
                    "pascal"
                ],
            ],
            "default" => "KG"
        ];

        //FashionNecklaceBraceletAnklet

        $i = "ProductData_Jewelry_ProductType_FashionNecklaceBraceletAnklet_";

        $subAttributes["{$i}VariationData_Length_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "KG"
        ];

        //FashionRing

        $i = "ProductData_Jewelry_ProductType_FashionRing_";

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "KG"
        ];

        //FashionEarring

        $i = "ProductData_Jewelry_ProductType_FashionEarring_";

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        //FashionOther

        $i = "ProductData_Jewelry_ProductType_FashionOther_";

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        //FineNecklaceBraceletAnklet

        $i = "ProductData_Jewelry_ProductType_FineNecklaceBraceletAnklet_";

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        //FineRing

        $i = "ProductData_Jewelry_ProductType_FineRing_";

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Stone_LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        // FineEarring

        $i = "ProductData_Jewelry_ProductType_FineEarring_";

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CM"
        ];

        //FineOther

        $i = "ProductData_Jewelry_ProductType_FineOther_";

        $subAttributes["{$i}Length_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}TotalDiamondWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalGemWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}TotalMetalWeight_unitOfMeasure_JewelryWeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}Diameter_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Height_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}Width_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneHeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneLength_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWidth_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "IN",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}StoneWeight_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        $subAttributes["{$i}LabCreated_unitOfMeasure_JewelryShapeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "CARATS",
                    "DWT",
                ],
            ],
            "default" => "CARATS"
        ];

        return $subAttributes;
    }
}
