<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Gourmet extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_GOURMET_MISC = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Gourmet';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "GourmetMisc":
                $this->attributes = array_merge($this->attributes, $this->getGourmetMisc());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Gourmet => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Gourmet_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getGourmetMisc()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Gourmet => 10
         * ProductType => 10
         * GourmetMis => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Gourmet_ProductType_GourmetMis_";

        $this->attributes = [
            "ProductData_Gourmet_ProductType_GourmetMis" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "GourmetMis",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Size",
                                "Color",
                                "Flavor",
                                "Flavor-Size",
                            ],
                    ],
            ],
            "{$i}Size" => [
                "sequence" => "{$s}20",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Flavor" => [
                "sequence" => "{$s}40",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}50",
                "name" => "CountryProducedIn",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}60",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Gourmet_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
