<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class GiftCard extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_GIFT_CARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PHYSICAL_GIFT_CARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ELECTRONIC_GIFT_CARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'GiftCard';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        // Overriding Barcode as not required.
        $this->attributes['StandardProductID_Value'] = [
            'sequence' => '20\20',
            'name' => 'Barcode',
            'dataType' => "Barcode",
            'minOccurs' => '0',
            "length" => "8:16"
        ];

        switch ($this->subCategory) {
            case "GiftCard":
                $this->attributes = array_merge($this->attributes, $this->getGiftCard());
                break;
            case "PhysicalGiftCard":
                $this->attributes = array_merge($this->attributes, $this->getPhysicalGiftCard());
                break;
            case "ElectronicGiftCard":
                $this->attributes = array_merge($this->attributes, $this->getElectronicGiftCard());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * GiftCard => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_GiftCard_";
        $common = [
            "{$i}Color" => [
                "sequence" => "{$s}20",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DesignName" => [
                "sequence" => "{$s}30",
                "name" => "DesignName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Genre" => [
                "sequence" => "{$s}50",
                "name" => "Genre",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}150\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}150\\10",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Denomination",
                        "Denomination-DesignName",
                        "StyleName",
                        "Denomination-DesignName-StyleName",
                    ],
                ],
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getGiftCard()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * GiftCard => 10
         * ProductType => 10
         * GiftCard => 100
         */
        $s = "100\\10\\10\\100\\";

        /**
         * Index prefix
         */
        $i = "ProductData_GiftCard_ProductType_GiftCard_";

        $attributes = [
            "ProductData_GiftCard_ProductType_GiftCard" => [
                "sequence" => "100\\10\\10\\100",
                "name" => "GiftCard",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getPhysicalGiftCard()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * GiftCard => 10
         * ProductType => 10
         * PhysicalGiftCard => 200
         */
        $s = "100\\10\\10\\200\\";

        /**
         * Index prefix
         */
        $i = "ProductData_GiftCard_ProductType_PhysicalGiftCard_";

        $attributes = [
            "ProductData_GiftCard_ProductType_PhysicalGiftCard" => [
                "sequence" => "100\\10\\10\\200",
                "name" => "PhysicalGiftCard",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getElectronicGiftCard()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * GiftCard => 10
         * ProductType => 10
         * ElectronicGiftCard => 300
         */
        $s = "100\\10\\10\\300\\";

        /**
         * Index prefix
         */
        $i = "ProductData_GiftCard_ProductType_ElectronicGiftCard_";

        $attributes = [
            "ProductData_GiftCard_ProductType_ElectronicGiftCard" => [
                "sequence" => "100\\10\\10\\300",
                "name" => "ElectronicGiftCard",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_GiftCard_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
