<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Furniture extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_FURNITURE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Furniture';
        $this->data["ProductData_{$this->category}_ProductType"] = $subCategory;
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        $this->attributes['DescriptionData_Manufacturer']['minOccurs'] = '1';
        $this->attributes['DescriptionData_RecommendedBrowseNode']['minOccurs'] = '1';

        switch ($this->subCategory) {
            case "Furniture":
                $this->attributes = array_merge($this->attributes, $this->getFurniture());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Furniture => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Furniture_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "documentation" => "Use of this element is deprecated. Please use Home/Parentage instead. " .
                    "This element is present for backward-compatibility reasons only.",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            // Test
            /*"{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\20",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\30",
                "name" => "Color",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],*/
            // Test  - end
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Quantity",
                        "SizeName",
                        "ColorName",
                        "SizeName-ColorName",
                    ],
                ],
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}20\\10",
                "name" => "AreBatteriesIncluded",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}20\\20",
                "name" => "AreBatteriesRequired",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}20\\30\\10",
                "name" => "BatteryType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "battery_type_2/3A",
                        1 => "battery_type_4/3A",
                        2 => "battery_type_4/5A",
                        3 => "battery_type_9v",
                        4 => "battery_type_12v",
                        5 => "battery_type_a",
                        6 => "battery_type_a76",
                        7 => "battery_type_aa",
                        8 => "battery_type_aaa",
                        9 => "battery_type_aaaa",
                        10 => "battery_type_c",
                        11 => "battery_type_cr123a",
                        12 => "battery_type_cr2",
                        13 => "battery_type_cr5",
                        14 => "battery_type_d",
                        15 => "battery_type_lithium_ion",
                        16 => "battery_type_lithium_metal",
                        17 => "battery_type_L-SC",
                        18 => "battery_type_p76",
                        19 => "battery_type_product_specific",
                        20 => "battery_type_SC",
                    ],
                ],
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}20\\30\\20",
                "name" => "NumberOfBatteries",
                "dataType" => "positiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}Model" => [
                "sequence" => "{$s}30",
                "name" => "Model",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
            ],
            "{$i}FabricWeight" => [
                "sequence" => "{$s}40",
                "name" => "FabricWeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}FabricWeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Occasion" => [
                "sequence" => "{$s}50",
                "name" => "Occasion",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}IncludedComponents" => [
                "sequence" => "{$s}60",
                "name" => "IncludedComponents",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Shape" => [
                "sequence" => "{$s}70",
                "name" => "Shape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Pattern" => [
                "sequence" => "{$s}80",
                "name" => "Pattern",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Striped",
                        "aboriginal",
                        "argyle",
                        "basketweave",
                        "bead_and_reel",
                        "camouflage",
                        "checker",
                        "chevron",
                        "damask",
                        "fleur_de_lis",
                        "floral",
                        "fret",
                        "houndstooth",
                        "ikat",
                        "lattice",
                        "moroccan",
                        "ogee",
                        "palmette",
                        "quatrefoil",
                        "scales",
                        "scroll",
                        "stripes",
                        "trellis",
                        "Bordered",
                        "Checkered",
                        "Geometric",
                        "Gingham",
                        "Moiré",
                        "Paisley",
                        "Patchwork",
                        "Plaid",
                        "Polka_Dot",
                        "Print",
                        "Solid",
                    ]
                ]
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}90",
                "name" => "SpecialFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Wattage" => [
                "sequence" => "{$s}100",
                "name" => "Wattage",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}Wattage_unitOfMeasure_WattageUnitOfMeasure"
            ],
            "{$i}Style" => [
                "sequence" => "{$s}105",
                "name" => "Style",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Windsor",
                        "Adam",
                        "American",
                        "Art_Deco",
                        "Art_Nouveau",
                        "Artisan",
                        "Arts_and_Crafts",
                        "Asian",
                        "Baroque",
                        "Bauhaus",
                        "Colonial",
                        "Contemporary",
                        "Cottage",
                        "Country",
                        "DeStijl",
                        "Directoire",
                        "Dutch",
                        "Early_American",
                        "Early_Renaissance",
                        "Elizabethan",
                        "Empire",
                        "English",
                        "European",
                        "Federal",
                        "Finnish",
                        "French",
                        "Georgian",
                        "Gothic",
                        "Greek",
                        "Hepplewhite",
                        "Italian_Renaissance",
                        "Jacobean",
                        "Japanese",
                        "Late_Renaissance",
                        "Louis_XVI",
                        "Middle_Ages",
                        "Middle_Renaissance",
                        "Minimalist",
                        "Mission",
                        "Modern",
                        "Neo_Gothic",
                        "Neoclassic",
                        "Oriental",
                        "Queen_Anne",
                        "Regal",
                        "Regency",
                        "Renaissance",
                        "Republic",
                        "Retro",
                        "Rietveld",
                        "Rococo",
                        "Romanesque",
                        "Russian",
                        "Rustic",
                        "Scandinavian",
                        "Shabby_Chic",
                        "Shaker",
                        "Sheraton",
                        "Spanish",
                        "Traditional",
                        "Tudor",
                        "Victorian",
                        "William_&_Mary",
                    ]
                ]
            ],
            "{$i}NumberOfPieces" => [
                "sequence" => "{$s}110",
                "name" => "NumberOfPieces",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}IsStainResistant" => [
                "sequence" => "{$s}120",
                "name" => "IsStainResistant",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}MaximumCoverageArea" => [
                "sequence" => "{$s}130",
                "name" => "MaximumCoverageArea",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}IsStainResistant_unitOfMeasure_AreaUnitOfMeasure"
            ],
            "{$i}LightSourceType" => [
                "sequence" => "{$s}140",
                "name" => "LightSourceType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PowerSource" => [
                "sequence" => "{$s}150",
                "name" => "PowerSource",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SeatHeight" => [
                "sequence" => "{$s}160",
                "name" => "SeatHeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}SeatHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}PaintType" => [
                "sequence" => "{$s}200",
                "name" => "PaintType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}IsFragile" => [
                "sequence" => "{$s}210",
                "name" => "IsFragile",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}Framed" => [
                "sequence" => "{$s}220",
                "name" => "Framed",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}FrameMaterial" => [
                "sequence" => "{$s}230",
                "name" => "FrameMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FrameColor" => [
                "sequence" => "{$s}240",
                "name" => "FrameColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DoorType" => [
                "sequence" => "{$s}250",
                "name" => "DoorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemTypeName" => [
                "sequence" => "{$s}260",
                "name" => "ItemTypeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}TopMaterial" => [
                "sequence" => "{$s}270",
                "name" => "TopMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfPanels" => [
                "sequence" => "{$s}280",
                "name" => "NumberOfPanels",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}NumberOfRails" => [
                "sequence" => "{$s}290",
                "name" => "NumberOfRails",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}CoverMaterial" => [
                "sequence" => "{$s}300",
                "name" => "CoverMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DesignName" => [
                "sequence" => "{$s}310",
                "name" => "DesignName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ShelfType" => [
                "sequence" => "{$s}320",
                "name" => "ShelfType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InstallationType" => [
                "sequence" => "{$s}330",
                "name" => "InstallationType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BackMaterial" => [
                "sequence" => "{$s}340",
                "name" => "BackMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LegFinish" => [
                "sequence" => "{$s}350",
                "name" => "LegFinish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FormFactor" => [
                "sequence" => "{$s}360",
                "name" => "FormFactor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}TopFinish" => [
                "sequence" => "{$s}370",
                "name" => "TopFinish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FrameType" => [
                "sequence" => "{$s}380",
                "name" => "FrameType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfHooks" => [
                "sequence" => "{$s}390",
                "name" => "NumberOfHooks",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LockType" => [
                "sequence" => "{$s}400",
                "name" => "LockType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}410",
                "name" => "ItemForm",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MetalType" => [
                "sequence" => "{$s}420",
                "name" => "MetalType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}430",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Wood",
                        "Fabric",
                        "Metal",
                        "Plastic",
                        "Porcelain",
                        "Cardboard",
                        "Ceramic",
                        "Glass",
                        "Stainless_Steel",
                        "alloy",
                        "bone china",
                        "brushed steel",
                        "carbon",
                        "cast aluminium",
                        "cast iron",
                        "cork",
                        "enamel",
                        "Faux Leather",
                        "hard-anodized aluminum",
                        "melamine",
                        "multi-ply",
                        "rattan & wicker",
                        "silicone",
                        "stainless steel",
                        "tinplate",
                        "titanium",
                    ]
                ]
            ],
            "{$i}FootboardUpholstery" => [
                "sequence" => "{$s}440",
                "name" => "FootboardUpholstery",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfSinks" => [
                "sequence" => "{$s}440",
                "name" => "NumberOfSinks",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}MaximumCompatibleThickness" => [
                "sequence" => "{$s}450",
                "name" => "MaximumCompatibleThickness",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}MaximumCompatibleThickness_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}MaximumSupportedScreenSize" => [
                "sequence" => "{$s}460",
                "name" => "MaximumSupportedScreenSize",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}MaximumSupportedScreenSize_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}StorageType" => [
                "sequence" => "{$s}470",
                "name" => "StorageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SinkMaterial" => [
                "sequence" => "{$s}480",
                "name" => "SinkMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BaseMaterial" => [
                "sequence" => "{$s}490",
                "name" => "BaseMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getFurniture()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Furniture => 10
         * ProductType => 10
         * Furniture => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Furniture_ProductType_Furniture_";
        $attributes = [
            "ProductData_Furniture_ProductType" => [
                "sequence" => "100\\10\\10",
                "name" => "Furniture",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Furniture_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}FabricWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" => [
                        0 => "GR",
                        1 => "KG",
                        2 => "OZ",
                        3 => "LB",
                        4 => "MG",
                    ],
                ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Wattage_unitOfMeasure_WattageUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" => [
                        0 => "watts",
                        1 => "kilowatts",
                    ],
                ],
            "default" => "watts"
        ];

        $subAttributes["{$i}IsStainResistant_unitOfMeasure_AreaUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "square-in",
                    "square-ft",
                    "square-cm",
                    "square-m",
                ],
            ],
            "default" => "square-cm"
        ];

        $subAttributes["{$i}SeatHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}MaximumCompatibleThickness_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}MaximumSupportedScreenSize_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "MM",
                    "CM",
                    "M",
                    "IN",
                    "FT",
                    "inches",
                    "feet",
                    "meters",
                    "decimeters",
                    "centimeters",
                    "millimeters",
                    "micrometers",
                    "nanometers",
                    "picometers",
                ],
            ],
            "default" => "CM"
        ];

        return $subAttributes;
    }
}
