<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class FoodServiceAndJanSan extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_FOOD_SERVICE_AND_JANSAN = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'FoodServiceAndJanSan';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "FoodServiceAndJanSan":
                $this->attributes = array_merge($this->attributes, $this->getFoodServiceAndJanSan());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * FoodServiceAndJanSan => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_FoodServiceAndJanSan_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getFoodServiceAndJanSan()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodServiceAndJanSan => 10
         * ProductType => 10
         * FoodServiceAndJanSan => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_FoodServiceAndJanSan_ProductType_FoodServiceAndJanSan_";

        $this->attributes = [
            "ProductData_FoodServiceAndJanSan_ProductType_FoodServiceAndJanSan" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "FoodServiceAndJanSan",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AgeRangeDescription" => [
                "sequence" => "{$s}50",
                "name" => "AgeRangeDescription",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}NumberOfItems" => [
                "sequence" => "{$s}300",
                "name" => "AgeRangeDescription",
                "dataType" => "decimal",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_FoodServiceAndJanSan_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
