<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class FoodAndBeverages extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_FOOD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HOUSEHOLD_SUPPLIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BEVERAGES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HARD_LIQUOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ALCOHOLIC_BEVERAGES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_WINE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BEER = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_SPIRITS = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'FoodAndBeverages';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Food":
                $this->attributes = array_merge($this->attributes, $this->getFood());
                break;
            case "HouseholdSupplies":
                $this->attributes = array_merge($this->attributes, $this->getHouseholdSupplies());
                break;
            case "Beverages":
                $this->attributes = array_merge($this->attributes, $this->getBeverages());
                break;
            case "HardLiquor":
                $this->attributes = array_merge($this->attributes, $this->getHardLiquor());
                break;
            case "AlcoholicBeverages":
                $this->attributes = array_merge($this->attributes, $this->getAlcoholicBeverages());
                break;
            case "Wine":
                $this->attributes = array_merge($this->attributes, $this->getWine());
                break;
            case "Beer":
                $this->attributes = array_merge($this->attributes, $this->getBeer());
                break;
            case "Spirits":
                $this->attributes = array_merge($this->attributes, $this->getSpirits());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getFood()
    {

        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * Food => 10
         */
        $s = "100\\10\\10\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_Food_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_Food" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Food",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}20",
                "name" => "CountryProducedIn",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}30",
                "name" => "ItemForm",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}40",
                "name" => "Ingredients",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getHouseholdSupplies()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * HouseholdSupplies => 20
         */
        $s = "100\\10\\10\\20\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_HouseholdSupplies_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_HouseholdSupplies" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "HouseholdSupplies",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}20",
                "name" => "CountryProducedIn",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}30",
                "name" => "ItemForm",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}40",
                "name" => "Ingredients",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getBeverages()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * Beverages => 30
         */
        $s = "100\\10\\10\\30\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_Beverages_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_Beverages" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "Beverages",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}20",
                "name" => "CountryProducedIn",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}30",
                "name" => "ItemForm",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}40",
                "name" => "Ingredients",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getHardLiquor()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * HardLiquor => 40
         */
        $s = "100\\10\\10\\40\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_HardLiquor_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_HardLiquor" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "HardLiquor",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}20",
                "name" => "CountryProducedIn",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}30",
                "name" => "ItemForm",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}40",
                "name" => "Ingredients",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getAlcoholicBeverages()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * AlcoholicBeverages => 50
         */
        $s = "100\\10\\10\\50\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_AlcoholicBeverages_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_AlcoholicBeverages" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "AlcoholicBeverages",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}20",
                "name" => "CountryProducedIn",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}30",
                "name" => "ItemForm",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}40",
                "name" => "Ingredients",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getWine()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * Wine => 60
         */
        $s = "100\\10\\10\\60\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_Wine_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_Wine" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "Wine",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}20",
                "name" => "CountryProducedIn",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemForm" => [
                "sequence" => "{$s}30",
                "name" => "ItemForm",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}40",
                "name" => "Ingredients",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getBeer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * Beer => 70
         */
        $s = "100\\10\\10\\70\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_Beer_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_Beer" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "Beer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Size",
                                "Flavor",
                                "Flavor-Size",
                                "StyleName",
                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_StyleName" => [
                "sequence" => "{$s}10\\50",
                "name" => "StyleName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}20",
                "name" => "Ingredients",
                "dataType" => "normalizedString",
                "minOccurs" => "0",
            ],
            "{$i}AlcoholType" => [
                "sequence" => "{$s}300",
                "name" => "AlcoholType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}WineSpiritsRating" => [
                "sequence" => "{$s}350",
                "name" => "WineSpiritsRating",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getSpirits()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * FoodAndBeverages => 10
         * ProductType => 10
         * Spirits => 80
         */
        $s = "100\\10\\10\\80\\";
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_ProductType_Spirits_";
        $this->attributes = [
            "ProductData_FoodAndBeverages_ProductType_Spirits" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "Spirits",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Size",
                                "Flavor",
                                "Flavor-Size",
                                "StyleName",
                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\40",
                "name" => "Flavor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_StyleName" => [
                "sequence" => "{$s}10\\50",
                "name" => "StyleName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}20",
                "name" => "Ingredients",
                "dataType" => "normalizedString",
                "minOccurs" => "0",
            ],
            "{$i}AlcoholType" => [
                "sequence" => "{$s}300",
                "name" => "AlcoholType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}WineSpiritsRating" => [
                "sequence" => "{$s}350",
                "name" => "WineSpiritsRating",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_FoodAndBeverages_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
