<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class EntertainmentCollectibles extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_ENTERTAINMENT_MEMORABILIA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'EntertainmentCollectibles';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "EntertainmentMemorabilia":
                $this->attributes = array_merge($this->attributes, $this->getEntertainmentMemorabilia());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * EntertainmentCollectibles => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_EntertainmentCollectibles_";
        return $this->attributes;
    }

    public function getEntertainmentMemorabilia()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * EntertainmentCollectibles => 10
         * ProductType => 10
         * EntertainmentMemorabilia => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_EntertainmentCollectibles_ProductType_EntertainmentMemorabilia_";

        $this->attributes = [
            "ProductData_EntertainmentCollectibles_ProductType_EntertainmentMemorabilia" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "EntertainmentMemorabilia",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AuthenticatedBy" => [
                "sequence" => "{$s}30",
                "name" => "AuthenticatedBy",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "psa",
                                "seller",
                            ],
                    ],
            ],
            "{$i}AuthenticityNumber" => [
                "sequence" => "{$s}40",
                "name" => "AuthenticityNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CollectibleType" => [
                "sequence" => "{$s}60",
                "name" => "CollectibleType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "original",
                                "original_limited_edition",
                                "reproduced",
                                "reproduced_limited_edition",
                            ],
                    ],
            ],
            "{$i}ConditionProvidedBy" => [
                "sequence" => "{$s}100",
                "name" => "ConditionProvidedBy",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "psa",
                                "seller",
                            ],
                    ],
            ],
            "{$i}GradeRating" => [
                "sequence" => "{$s}200",
                "name" => "GradeRating",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_EntertainmentCollectibles_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
