<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Collectibles extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_ADVERTISEMENT_COLLECTIBLES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HISTORICAL_COLLECTIBLES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Collectibles';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        // Overriding Barcode as not required.
        $this->attributes['StandardProductID_Value'] = [
            'sequence' => '20\20',
            'name' => 'Barcode',
            'dataType' => "Barcode",
            'minOccurs' => '0',
            "length" => "8:16"
        ];

        switch ($this->subCategory) {
            case "AdvertisementCollectibles":
                $this->attributes = array_merge($this->attributes, $this->getAdvertisementCollectibles());
                break;
            case "HistoricalCollectibles":
                $this->attributes = array_merge($this->attributes, $this->getHistoricalCollectibles());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Collectibles => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Collectibles_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getAdvertisementCollectibles()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Collectibles => 10
         * ProductType => 10
         * AdvertisementCollectibles => 10
         */
        $s = "100\\10\\10\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Collectibles_ProductType_AdvertisementCollectibles_";
        $attributes = [
            "ProductData_Collectibles_ProductType_AdvertisementCollectibles" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "AdvertisementCollectibles",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}MakeAnOfferMinimumPercentage" => [
                "sequence" => "{$s}100",
                "name" => "MakeAnOfferMinimumPercentage",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}DisplayHeight" => [
                "sequence" => "{$s}200",
                "name" => "DisplayHeight",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}300",
                "name" => "DisplayLength",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayWidth" => [
                "sequence" => "{$s}400",
                "name" => "DisplayWidth",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayWeight" => [
                "sequence" => "{$s}500",
                "name" => "DisplayWeight",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayWeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Theme" => [
                "sequence" => "{$s}600",
                "name" => "Theme",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}AdditionalProductInformation" => [
                "sequence" => "{$s}700",
                "name" => "AdditionalProductInformation",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}Originality" => [
                "sequence" => "{$s}800",
                "name" => "Originality",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        "Original",
                        "Original Limited Edition",
                        "Reproduced",
                        "Reproduced Limited Edition",
                        "Replica",
                        "Replica Limited Edition",
                        "Limited Edition",
                        "Manufactured",
                        "Licensed",
                        "Vintage",
                    ],
                ],
                "{$i}GradeRating" => [
                    "sequence" => "{$s}900",
                    "name" => "GradeRating",
                    "dataType" => "StringNotNull",
                    "minOccurs" => "1",
                ],
                "{$i}Genre" => [
                    "sequence" => "{$s}1000",
                    "name" => "Genre",
                    "dataType" => "StringNotNull",
                    "minOccurs" => "1",
                ],
                "{$i}AuthenticatedBy" => [
                    "sequence" => "{$s}1100",
                    "name" => "AuthenticatedBy",
                    "dataType" => "StringNotNull",
                    "minOccurs" => "0",
                ],
                "{$i}GradedBy" => [
                    "sequence" => "{$s}1200",
                    "name" => "GradedBy",
                    "dataType" => "StringNotNull",
                    "minOccurs" => "0",
                ],
                "{$i}ModelYear" => [
                    "sequence" => "{$s}1300",
                    "name" => "ModelYear",
                    "dataType" => "FourDigitYear",
                    "minOccurs" => "0",
                ],
                "{$i}EstatePeriod" => [
                    "sequence" => "{$s}1400",
                    "name" => "EstatePeriod",
                    "dataType" => "StringNotNull",
                    "minOccurs" => "0",
                ],
                "{$i}SizeName" => [
                    "sequence" => "{$s}1500",
                    "name" => "SizeName",
                    "dataType" => "StringNotNull",
                    "minOccurs" => "0",
                ],
                "{$i}IsVeryHighValue" => [
                    "sequence" => "{$s}1600",
                    "name" => "IsVeryHighValue",
                    "dataType" => "boolean",
                    "minOccurs" => "0",
                ],
                "{$i}IsAdultProduct" => [
                    "sequence" => "{$s}1700",
                    "name" => "IsAdultProduct",
                    "dataType" => "boolean",
                    "minOccurs" => "0",
                ],
                "{$i}CertificateNumber" => [
                    "sequence" => "{$s}1800",
                    "name" => "CertificateNumber",
                    "dataType" => "HundredString",
                    "minOccurs" => "0",
                ],
            ],
        ];

        return $attributes;
    }

    public function getHistoricalCollectibles()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Collectibles => 10
         * ProductType => 10
         * HistoricalCollectibles => 10
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Collectibles_ProductType_HistoricalCollectibles_";
        $attributes = [
            "ProductData_Collectibles_ProductType_HistoricalCollectibles" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "HistoricalCollectibles",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}MakeAnOfferMinimumPercentage" => [
                "sequence" => "{$s}100",
                "name" => "MakeAnOfferMinimumPercentage",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}DisplayHeight" => [
                "sequence" => "{$s}200",
                "name" => "DisplayHeight",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}300",
                "name" => "DisplayLength",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayWidth" => [
                "sequence" => "{$s}400",
                "name" => "DisplayWidth",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayWeight" => [
                "sequence" => "{$s}500",
                "name" => "DisplayWeight",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayWeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}StyleName" => [
                "sequence" => "{$s}600",
                "name" => "StyleName",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}Originality" => [
                "sequence" => "{$s}800",
                "name" => "Originality",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        "Original",
                        "Original Limited Edition",
                        "Reproduced",
                        "Reproduced Limited Edition",
                        "Replica",
                        "Replica Limited Edition",
                        "Limited Edition",
                        "Manufactured",
                        "Licensed",
                        "Vintage",
                    ],
                ],
            ],
            "{$i}GradeRating" => [
                "sequence" => "{$s}900",
                "name" => "GradeRating",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}1000",
                "name" => "ModelYear",
                "dataType" => "FourDigitYear",
                "minOccurs" => "0",
            ],
            "{$i}ModelYearRange" => [
                "sequence" => "{$s}1100",
                "name" => "ModelYearRange",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}EventName" => [
                "sequence" => "{$s}1125",
                "name" => "EventName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}AuthenticatedBy" => [
                "sequence" => "{$s}1150",
                "name" => "AuthenticatedBy",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}GradedBy" => [
                "sequence" => "{$s}1200",
                "name" => "GradedBy",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Contributor" => [
                "sequence" => "{$s}1300",
                "name" => "Contributor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CertificateNumber" => [
                "sequence" => "{$s}1400",
                "name" => "CertificateNumber",
                "dataType" => "HundredString",
                "minOccurs" => "0",
            ],
            "{$i}LimitedEditionNumber" => [
                "sequence" => "{$s}1400",
                "name" => "LimitedEditionNumber",
                "dataType" => "HundredString",
                "minOccurs" => "0",
            ],
            "{$i}LimitedEditionQuantity" => [
                "sequence" => "{$s}1500",
                "name" => "LimitedEditionQuantity",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}IsVeryHighValue" => [
                "sequence" => "{$s}1600",
                "name" => "IsVeryHighValue",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}IsAdultProduct" => [
                "sequence" => "{$s}1700",
                "name" => "IsAdultProduct",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],

            "{$i}AdditionalProductInformation" => [
                "sequence" => "{$s}1800",
                "name" => "AdditionalProductInformation",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Collectibles_";

        $subAttributes = self::SUB_ATTRIBUTES;

        switch ($this->subCategory) {
            case "AdvertisementCollectibles":
                $subAttributes = array_merge($subAttributes, $this->getSubAdvertisementCollectibles());
                break;
            case "HistoricalCollectibles":
                $subAttributes = array_merge($subAttributes, $this->getSubHistoricalCollectibles());
                break;
        }

        return $subAttributes;
    }

    public function getSubAdvertisementCollectibles()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Collectibles_ProductType_AdvertisementCollectibles_";

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "MM",
                            "CM",
                            "M",
                            "IN",
                            "FT",
                            "inches",
                            "feet",
                            "meters",
                            "decimeters",
                            "centimeters",
                            "millimeters",
                            "micrometers",
                            "nanometers",
                            "picometers",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "MM",
                            "CM",
                            "M",
                            "IN",
                            "FT",
                            "inches",
                            "feet",
                            "meters",
                            "decimeters",
                            "centimeters",
                            "millimeters",
                            "micrometers",
                            "nanometers",
                            "picometers",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "MM",
                            "CM",
                            "M",
                            "IN",
                            "FT",
                            "inches",
                            "feet",
                            "meters",
                            "decimeters",
                            "centimeters",
                            "millimeters",
                            "micrometers",
                            "nanometers",
                            "picometers",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "GR",
                            "KG",
                            "OZ",
                            "LB",
                            "MG",
                        ],
                ],
            "default" => "KG"
        ];

        return $subAttributes;
    }

    public function getSubHistoricalCollectibles()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Collectibles_ProductType_HistoricalCollectibles_";

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "MM",
                            "CM",
                            "M",
                            "IN",
                            "FT",
                            "inches",
                            "feet",
                            "meters",
                            "decimeters",
                            "centimeters",
                            "millimeters",
                            "micrometers",
                            "nanometers",
                            "picometers",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "MM",
                            "CM",
                            "M",
                            "IN",
                            "FT",
                            "inches",
                            "feet",
                            "meters",
                            "decimeters",
                            "centimeters",
                            "millimeters",
                            "micrometers",
                            "nanometers",
                            "picometers",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "MM",
                            "CM",
                            "M",
                            "IN",
                            "FT",
                            "inches",
                            "feet",
                            "meters",
                            "decimeters",
                            "centimeters",
                            "millimeters",
                            "micrometers",
                            "nanometers",
                            "picometers",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            "GR",
                            "KG",
                            "OZ",
                            "LB",
                            "MG",
                        ],
                ],
            "default" => "KG"
        ];

        return $subAttributes;
    }
}
