<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;


class Baby extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_BABY_PRODUCTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Baby';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }
        switch ($this->subCategory) {
            case "BabyProducts":
                $this->attributes = array_merge($this->attributes, $this->getBabyProducts());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Baby => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Baby_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getBabyProducts()
    {
        return [];
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Baby_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}