<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class AutoAccessory extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_SPAIN,
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_UK,
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_FRANCE,
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_GERMANY,
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_ITALY,
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA,
    ];
    const ALLOWED_MARKETPLACE_MOTORCYCLE_ACCESSORY = self::ALLOWED_MARKETPLACE;
    const ALLOWED_MARKETPLACE_AUTOPART_ACCESSORY = self::ALLOWED_MARKETPLACE;
    const ALLOWED_MARKETPLACE_AUTOACCESSORYMISC = self::ALLOWED_MARKETPLACE;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'AutoAccessory';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;
        $this->attributes['Condition_ConditionType'] = [
            'sequence' => '30\30',
            'name' => 'Condition',
            'dataType' => "StringNotNull",
            'minOccurs' => '1',
            "restriction" => [
                "optionValues" => [
                    "New",
                    "UsedLikeNew",
                    "UsedVeryGood",
                    "UsedGood",
                    "UsedAcceptable",
                    "CollectibleLikeNew",
                    "CollectibleVeryGood",
                    "CollectibleGood",
                    "CollectibleAcceptable",
                    "Refurbished", // India Only
                    "Club",
                ],
            ]
        ];
        $this->attributes['DescriptionData_Manufacturer'] = [
            'sequence' => '30\150',
            'name' => 'Manufacturer',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];
        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Motorcycleaccessory":
                $this->attributes = array_merge($this->attributes, $this->getMotorcycleaccessory());
                break;
            case "AutoPart":
                $this->attributes = array_merge($this->attributes, $this->getAutoParts());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * AutoAccessory => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_AutoAccessory_";

        $common = [
            "{$i}Parentage" => [
                "sequence" => "{$s}20",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "collection-parent",
                        1 => "variation-parent",
                        2 => "base-product",
                        3 => "parent",
                        4 => "child",
                    ],
                ],
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}10\\10",
                "name" => "AreBatteriesIncluded",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}10\\20",
                "name" => "AreBatteriesRequired",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}10\\30\\10",
                "name" => "BatteryType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "battery_type_2/3A",
                        1 => "battery_type_4/3A",
                        2 => "battery_type_4/5A",
                        3 => "battery_type_9v",
                        4 => "battery_type_12v",
                        5 => "battery_type_a",
                        6 => "battery_type_a76",
                        7 => "battery_type_aa",
                        8 => "battery_type_aaa",
                        9 => "battery_type_aaaa",
                        10 => "battery_type_c",
                        11 => "battery_type_cr123a",
                        12 => "battery_type_cr2",
                        13 => "battery_type_cr5",
                        14 => "battery_type_d",
                        15 => "battery_type_lithium_ion",
                        16 => "battery_type_lithium_metal",
                        17 => "battery_type_L-SC",
                        18 => "battery_type_p76",
                        19 => "battery_type_product_specific",
                        20 => "battery_type_SC",
                    ],
                ],
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}10\\30\\20",
                "name" => "NumberOfBatteries",
                "dataType" => "positiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}30\\40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}30\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],

        ];

        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getMotorcycleaccessory()
    {
        // Overriding the MfrPartNumber
        $this->attributes['DescriptionData_MfrPartNumber'] = [
            'sequence' => '30\160',
            'name' => 'MfrPartNumber',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];

        /**
         * Sequence prefix
         * ProductData => 100
         * AutoAccessory => 10
         * ProductType => 10
         * Motorcycleaccessory => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_AutoAccessory_ProductType_Motorcycleaccessory_";

        $attributes = [
            "ProductData_AutoAccessory_ProductType_Motorcycleaccessory" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Motorcycleaccessory",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}Parentage" => [
                "sequence" => "{$s}10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\10",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Size-Color",
                    ],
                ],
            ],
        ];

        return $attributes;
    }

    public function getAutoParts()
    {
        // Overriding the MfrPartNumber
        $this->attributes['DescriptionData_MfrPartNumber'] = [
            'sequence' => '30\160',
            'name' => 'MfrPartNumber',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1',
        ];

        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_AutoAccessory_ProductType_AutoPart_";

        $attributes = [
            "ProductData_AutoAccessory_ProductType_AutoPart" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "AutoPart",
                "dataType" => "string",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\10",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Size-Color",
                    ],
                ],
            ],
            "{$i}ColorSpecification_Color" => [
                "sequence" => "{$s}30\\10",
                "name" => "Color",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ColorSpecification_ColorMap" => [
                "sequence" => "{$s}30\\20",
                "name" => "ColorMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}30\\30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VehicleFitmentCode" => [
                "sequence" => "{$s}40\\20\\10",
                "name" => "VehicleFitmentCode",
                "dataType" => "TwoThousandString",
                "minOccurs" => "0ss",
            ],
            "{$i}VehicleFitmentNote" => [
                "sequence" => "{$s}50\\30\\20\\10",
                "name" => "VehicleFitmentNote",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}VehicleFitmentStandard" => [
                "sequence" => "{$s}60\\40\\30\\20\\10",
                "name" => "VehicleFitmentStandard",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ]
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_AutoAccessory_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}SeatHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "MM",
                    1 => "CM",
                    2 => "M",
                ],
            ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "cubic-cm",
                    1 => "cubic-ft",
                    2 => "cubic-in",
                    3 => "cubic-m",
                    4 => "cubic-yd",
                    5 => "cup",
                    6 => "fluid-oz",
                    7 => "gallon",
                    8 => "liter",
                    9 => "milliliter",
                    10 => "ounce",
                    11 => "pint",
                    12 => "quart",
                    13 => "liters",
                    14 => "deciliters",
                    15 => "centiliters",
                    16 => "milliliters",
                    17 => "microliters",
                    18 => "nanoliters",
                    19 => "picoliters",
                ],
            ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "GR",
                    1 => "KG",
                    2 => "OZ",
                    3 => "LB",
                    4 => "MG",
                ],
            ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Volume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "cubic-cm",
                    1 => "cubic-ft",
                    2 => "cubic-in",
                    3 => "cubic-m",
                    4 => "cubic-yd",
                    5 => "cup",
                    6 => "fluid-oz",
                    7 => "gallon",
                    8 => "liter",
                    9 => "milliliter",
                    10 => "ounce",
                    11 => "pint",
                    12 => "quart",
                    13 => "liters",
                    14 => "deciliters",
                    15 => "centiliters",
                    16 => "milliliters",
                    17 => "microliters",
                    18 => "nanoliters",
                    19 => "picoliters",
                ],
            ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}VolumeCapacity_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    0 => "cubic-cm",
                    1 => "cubic-ft",
                    2 => "cubic-in",
                    3 => "cubic-m",
                    4 => "cubic-yd",
                    5 => "cup",
                    6 => "fluid-oz",
                    7 => "gallon",
                    8 => "liter",
                    9 => "milliliter",
                    10 => "ounce",
                    11 => "pint",
                    12 => "quart",
                    13 => "liters",
                    14 => "deciliters",
                    15 => "centiliters",
                    16 => "milliliters",
                    17 => "microliters",
                    18 => "nanoliters",
                    19 => "picoliters",
                ],
            ],
            "default" => "cubic-cm"
        ];

        switch ($this->category) {
            case "Motorcycleaccessory":
                $subAttributes = array_merge($subAttributes, $this->getSubMotorcycleaccessory());
                break;
        }

        return $subAttributes;
    }

    public function getSubMotorcycleaccessory()
    {
        $i = "ProductData_AutoAccessory_ProductType_Motorcycleaccessory_";
        $subAttributes = [
            "{$i}MaximumCoverageArea_unitOfMeasure_AreaUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        0 => "square-in",
                        1 => "square-ft",
                        2 => "square-cm",
                        3 => "square-m",
                    ],
                ],
                "default" => "square-cm"
            ],
            "{$i}OutputCapacity_unitOfMeasure_VolumeRateUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        0 => "milliliters per second",
                        1 => "centiliters per second",
                        2 => "liters per second",
                        3 => "milliliters per minute",
                        4 => "liters per minute",
                        5 => "microliters per second",
                        6 => "nanoliters per second",
                        7 => "picoliters per second",
                        8 => "microliters per minute",
                        9 => "nanoliters per minute",
                        10 => "picoliters per minute",
                        11 => "gallons_per_day",
                        12 => "gallons_per_day",
                        13 => "liters_per_day",
                        14 => "liters",
                    ],
                ],
                "default" => "milliliters per second"
            ],
            "{$i}TowelWeight_unitOfMeasure_WeightUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        0 => "GR",
                        1 => "KG",
                        2 => "OZ",
                        3 => "LB",
                        4 => "MG",
                    ],
                ],
                "default" => "KG"
            ],
            "{$i}Wattage_unitOfMeasure_WattageUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        0 => "watts",
                        1 => "kilowatts",
                    ],
                ],
                "default" => "watts"
            ],
        ];
        return $subAttributes;
    }
}
